@extends('layouts.masterDashboard')
@section('content')
    <div class="row">
        <div class="col-md">
            <div class="card card-user">
                <div class="card-header pt-4" style="align-self: center;justify-content: center;width: 75%;border-bottom: none;">
                    <h3>{{ isset($eventList) ? "Existing Events" : (isset($eventAssign) ? "Assign Vendor" : (isset($noList) ? "Choose Event By Status" : "")) }}</h3>
                </div>
                <div class="card-body">
                    @if(isset($noList))
                        <div class="d-flex justify-content-center">
                            <button class="peterriver w-75 mr-4" style="padding: .3rem .2rem;" onclick="redirection('{{ url('events/newList') }}');">New Events</button>
                            <button class="peterriver w-75 mx-4" style="padding: .3rem .2rem;" onclick="redirection('{{ url('events/pendingList') }}');">Pending Events</button>
                            <button class="peterriver w-75 mx-4" style="padding: .3rem .2rem;" onclick="redirection('{{ url('events/approvedList') }}');">Approved Events</button>
                            <button class="peterriver w-75 ml-4" style="padding: .3rem .2rem;" onclick="redirection('{{ url('events/declineList') }}');">Declined Events</button>
                        </div>
                    @elseif(isset($eventList))
                        <?php
                            // dd($eventList);
                        ?>
                        <div class="table-responsive p-2" style="overflow-x: scroll; overflow-y: hidden;">
                            <table class="table table-hover">
                                <thead class="text-dark border-bottom">
                                    <tr>
                                        <th class="text-center border-bottom-0" scope="col">S.No.</th> 
                                        <th class="text-center border-bottom-0" scope="col">Client Name</th>
                                        <th class="text-center border-bottom-0" scope="col">Client Code</th>
                                        <th class="text-center border-bottom-0" scope="col">Date</th>
                                        <th class="text-center border-bottom-0" scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($eventList as $key => $event)
                                        <tr>
                                            <td class="text-center" scope="row">{{ $loop->iteration }}</td>
                                            <td class="text-center">{{ $event->client_name }}</td>
                                            <td class="text-center">{{ $event->client_username }}</td>
                                            <td class="text-center">{{ date('d/m/Y', $event['eventDate']) }}</td>
                                            <td class="d-flex justify-content-center">
                                                <?php
                                                    $url = $event->eventDate.'/'.$event->id;
                                                ?>
                                                @if($type == "newList" || $type == "declineList")
                                                    <div class="peterriver w-75" style="padding: .3rem .2rem;" onclick="redirection('{{ url('events/assign').'/'.$url }}');">View Details</div>
                                                @elseif($type == "pendingList")
                                                    <div class="peterriver w-75" style="padding: .3rem .2rem;" onclick="redirection('{{ url('events/remove').'/'.$url }}');">Delete Vendor</div>
                                                @elseif($type == "approvedList")
                                                    <div class="peterriver w-75" style="padding: .3rem .2rem;" onclick="redirection('{{ url('events/view').'/'.$url }}');">View Vendor</div>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" align="center">{{ !isset($type) ? "" : ($type == "newList" ? "No New Events Yet!" : ($type == "pendingList" ? "No Pending Events Yet!" : ($type == "approvedList" ? "No Approved Events Yet!" : ($type == "declineList" ? "No Declined Events Yet!" : "")))) }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    @elseif(isset($eventAssign))
                        <?php
                            // dd($eventAssign);
                        ?>
                        <form method="POST" action="{{ url('client/event/assign') }}">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="clientId" value="{{ $eventAssign->clientId }}" />
                            <div class="row">
                                <div class="col-md-4 col-sm-12 pr-md-1">
                                    <div class="form-group">
                                        <label for="reservationDate">Date of Event</label>
                                        <div class="input-group p-0 shadow-sm">
                                            <input type="text" name="reservationDate" class="form-control" value="{{ date('d/m/Y', $eventAssign->eventDate) }}" readonly />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="guestsNumber">Guests Number</label>
                                        <input type="text" name="guestsNumber" class="form-control" value="{{ $eventAssign->guestNumber }}" readonly />
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12">
                                    <div class="form-group">
                                        <label for="plateRate">Rates Per Plate</label>
                                        <input class="form-control shadow-sm" name="plateRate" value="{{ $eventAssign->ratePerPlate }}" readonly />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Type of Event</span></h5>
                                        <div class="d-flex justify-content-between flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="corporateEvent" <?php echo empty($eventAssign->typeOfEvent) ? "" : ($eventAssign->typeOfEvent == "corporateEvent" ? "checked disabled" : "disabled") ?> />
                                                <span>Corporate Event</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="indoorThemeEvent" <?php echo empty($eventAssign->typeOfEvent) ? "" : ($eventAssign->typeOfEvent == "indoorThemeEvent" ? "checked disabled" : "disabled") ?> />
                                                <span>Indoor Theme Event</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="odc" <?php echo empty($eventAssign->typeOfEvent) ? "" : ($eventAssign->typeOfEvent == "odc" ? "checked disabled" : "disabled") ?> />
                                                <span>ODC</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventType" value="outdoorThemeEvent" <?php echo empty($eventAssign->typeOfEvent) ? "" : ($eventAssign->typeOfEvent == "outdoorThemeEvent" ? "checked disabled" : "disabled") ?> />
                                                <span>Outdoor Theme Event</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Decoration needed</span></h5>
                                        <div class="d-flex justify-content-around flex-wrap">
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="yes" <?php echo empty($eventAssign->decorationNeeded) ? "" : ($eventAssign->decorationNeeded == "yes" ? "checked disabled" : "disabled") ?> />
                                                <span>Yes</span>
                                            </label>
                                            <label class="radio mx-4 my-2">
                                                <input type="radio" name="eventDecoration" value="no" <?php echo empty($eventAssign->decorationNeeded) ? "" : ($eventAssign->decorationNeeded == "no" ? "checked disabled" : "disabled") ?> />
                                                <span>No</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <h5 class="text-center d-flex justify-content-center"><span class="border-bottom">Assign Vendor</span></h5>
                                        <div class="d-flex justify-content-between flex-wrap">
                                            @if($type == "view")
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="vendorType" value="existingVendor" <?php echo (isset($vendorList) ? "checked disabled" : "disabled") ?> />
                                                    <span>Choose Existing Vendor</span>
                                                </label>
                                                <label class="radio mx-4 my-2">
                                                    <input type="radio" name="vendorType" value="otherVendor" <?php echo (isset($vendorList) ? "disabled" : "checked disabled") ?> />
                                                    <span>Other Vendor</span>
                                                </label>
                                            @else
                                                <label class="radio mx-4 my-2" onclick="enable();">
                                                    <input type="radio" name="vendorType" value="existingVendor" checked />
                                                    <span>Choose Existing Vendor</span>
                                                </label>
                                                <label class="radio mx-4 my-2" onclick="disable();">
                                                    <input type="radio" name="vendorType" value="otherVendor" />
                                                    <span>Other Vendor</span>
                                                </label>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="existingVendor">Choose Existing Vendor</label>
                                        <select class="selectpicker" name="existingVendor[]" id="existingVendor" required <?php echo !isset($type) ? "" : ($type == "view" ? "disabled" : "") ?> multiple>
                                            <option value="{{ $type == 'view' ? (isset($vendorList) ? $vendorList->name : '') : '' }}" checked>{{ $type == 'view' ? (isset($vendorList) ? $vendorList->name : '') : '' }}</option>
                                            @if($type == "assign")
                                                @forelse($vendorList as $value)
                                                    <option value="{{ $value->vendorId }}">{{ $value->name }}</option>
                                                @empty
                                                    <option value="corporate">Seems No Vendor Yet!</option>
                                                @endforelse
                                            @endif
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row d-flex justify-content-center">
                                <div class="back">
                                    <div class="wetasphalt" style="font-weight: bolder;font-size: medium;padding: 0.4rem 1.4rem;" onclick="redirection('{{ url()->previous() }}');">Back</div>
                                </div>
                                @if($type !== "view")
                                    <div class="assign">
                                        <button type="submit" class="turquoise" style="padding: .4rem 1rem;width: auto;font-size: 1rem;">Assign</button>
                                    </div>
                                @endif
                            </div>
                        </form>
                        @section('customscript')
                            <script>
                                $('select').selectpicker();
                            </script>
                        @endsection
                    @endif
                </div>
                @if(isset($eventList))
                    <div class="card-footer p-0" style="align-self: center;text-align: center;border-bottom: none;border-top: none;color: #d45353;display: flex;justify-content: center;">
                        <h6>{{ $eventList->links() }}</h6>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        function disable(){
            $("select#existingVendor").prop('disabled', true);
            $('select#existingVendor').removeAttr('required');
        }
        function enable(){
            $("select#existingVendor").prop('disabled', false);
        }
    </script>
@endsection