<?php

namespace App\Modules\Admin\Controllers;

use App\AIFeed;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Request;
use App\Mail\SendMail;
use Carbon\Carbon;
use Validator;
use Storage;
use Auth;
use Hash;
use File;
use DB;

use App\MealCountDetail;
use App\ConcernMessage;
use App\Notifications;
use App\QRScanDetail;
use App\RaiseConcern;
use App\MarshalDocs;
use App\ClientDocs;
use App\VendorDocs;
use App\RolesEvent;
use App\ClientsEmp;
use App\QRDetail;
use App\Invoice;
use App\MapRole;
use App\Marshal;
use App\Vendor;
use App\Client;
use App\User;
use App\MealRateList;
use App\Type4QrScanDetail;

use App\Exports\UsersExport;
use App\Exports\InvoiceExport;
use App\Exports\ReportExport;
use App\Modules\Vendor\Models\Vendor as ModelsVendor;
use App\VendorCameras;
use Excel;
use QrCode;
use Image;

class AdminController extends Controller {

    use RegistersUsers;

    protected $waiting = "Client event is on hold and no vendor has been assigned to him/her by Admin yet.";
    protected $pending = "Vendor has been assigned but not approved/decline by the Vendor yet.";
    protected $assigined = "Vendor has approved the client event.";

    public function __construct() {
        $this->middleware('auth');
    }

    public function download_as_report(string $format, string $role=null)
    {
        // dd("Download");
        $users = [];
        $role = strtolower($role);
        $common_fields = ['name', 'email', 'users.username', 'contactNumber', 'address'];
        switch ($role) {
            case "client":
                $client_fields = ['contactName', 'employeeNumber', 'headOffice', 'clientCategory', 'typeOfServices', 'clientScopeCafe', 'paymentTerms', 'typeServiceSuggestion', 'clientScopeSuggestion', 'created_at'];
                $users = User::role($role)
                    ->join('clients', 'users.id', '=', 'clients.clientId')
                    ->select(array_merge($common_fields, $client_fields));
                break;
            case "sitemarshal":
                $marshal_fields = ['designation', 'employeeId', 'govId', 'expInYrs', 'siteAssigned', 'assignedSite'];
                $users = User::role($role)
                    ->join('marshals', 'users.id', '=', 'marshals.marshalId')
                    ->select(array_merge($common_fields, $marshal_fields));
                break;
            case "vendor":
                $vendor_fields = ['contactName', 'companyRole', 'employeeNumber', 'yearExp', 'kitchenArea', 'mealCapacity', 'companyType', 'vendorScope', 'auditRating', 'cameraNumber', 'cameraMegaPixel'];
                $users = User::role($role)
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select(array_merge($common_fields, $vendor_fields));
                break;
            default:
                echo "No Role is submitted Yet!";
        }

        $export = new UsersExport([$users->get()->toArray()]);
        // dd($export);
        $filename = $role . "." . $format;
        return Excel::download($export, $filename);
    }

    protected function remove_empty_array_values($arr){
        foreach($arr as $key => $value){
            if(empty($value)){
                unset($arr[$key]);
            }
        }
        return $arr;
    }

    public function roles($type, $search)
    {
        switch (strtolower($type)) {
            case "client":
                return User::role(strtolower($type))
                    ->join('clients', 'users.id', '=', 'clients.clientId')
                    ->where('users.name', 'LIKE', "%{$search}%")
                    ->groupBy('clients.username')
                    ->orderBy('created_at', 'desc')
                    ->paginate(4);
                break;
            case "sitemarshal":
                return User::role(strtolower($type))
                    ->join('marshals', 'users.id', '=', 'marshals.marshalId')
                    ->where('users.name', 'LIKE', "%{$search}%")
                    ->groupBy('marshals.username')
                    ->orderBy('created_at', 'desc')
                    ->paginate(4);
                break;
            case "vendor":
                return User::role(strtolower($type))
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->where('users.name', 'LIKE', "%{$search}%")
                    ->groupBy('vendors.username')
                    ->orderBy('created_at', 'desc')
                    ->paginate(4);
                break;
            default:
                echo "No Role is submitted Yet!";
        }
    }

    public function list_roles(Request $request, $type, $search=null)
    {
        if($request->ajax()){
            // sleep(1);
            $data = $this->roles($type, $search);
            return $data;
        }
        return view('Admin::listAll', compact('type'));
    }

    public function create($roleType){
        $roleType = strtolower($roleType);
        // return view('Admin::register', compact('roleType'));
        if($roleType == "client"){
            return view('Admin::register/create/register_client', compact('roleType'));
        }elseif($roleType == "vendor"){
            return view('Admin::register/create/register_vendor', compact('roleType'));
        }elseif($roleType == "sitemarshal"){
            return view('Admin::register/create/register_marshal', compact('roleType'));
        }
    }

    protected function vendor_validation(array $allrequest)
    {
        return Validator::make($allrequest, [
            'name' => 'required|string|max:255',
            'contactName' => 'required|string|max:255',
            'contactNumber' => 'required|digits:10',
            'address' => 'required|string|max:400',
            'username' => 'required|string|max:255|unique:users',
            'email' => 'required|string|email|max:255|unique:users',
            //'password' => 'required|string|min:6|confirmed',

            'yearExp' => 'required|numeric|min:2',
            'companyRole' => 'required|string|max:100',
            'employeeNumber' => 'required|numeric|min:10',
            // 'kitchenArea' => 'required|numeric|min:500',
            'mealCapacity' => 'required|numeric|min:10',
            'companyType' => 'required|string|max:50',
            'vendorScope' => 'required|array|min:1',
            'auditRating' => 'required|string|max:50',
            'cameraNumber' => 'required|numeric|min:2',
            'cameraMegaPixel' => 'required|numeric|min:1',
        ]);
    }

    public function marshal_validation(array $allrequest)
    {
        return Validator::make($allrequest, [
            'name' => 'required|string|max:255',
            'contactNumber' => 'required|digits:10',
            'address' => 'required|string|max:400',
            'username' => 'required|string|max:255|unique:users',
            'email' => 'required|string|email|max:255|unique:users',
            //'password' => 'required|string|min:6|confirmed',

            'yearExp' => 'required|numeric|min:2',
            'designation' => 'required|string|max:25',
            // 'empId' => 'required|numeric|min:1',
            // 'govId' => 'required|numeric|min:6',
            'siteassigned' => 'required|string',
            'pro_pic' => 'image|mimes:jpeg,jpg,png|max:2000',
        ]);
    }

    protected function client_validation(array $allrequest)
    {
        return Validator::make($allrequest, [
            'name' => 'required|string|max:255',
            'contactName' => 'required|array|min:1|max:3',
            'contactNumber' => 'required|array|min:1|max:3',
            'address' => 'required|string|max:400',
            'username' => 'required|string|max:255|unique:users',
            'email' => 'required|string|email|max:255|unique:users',
            // 'password' => 'required|string|min:6|password_confirmation',
            //'password' => 'required|string|min:6|confirmed',

            'clientDocuments.*' => 'mimes:doc,pdf,docx,zip|max:10000',
            'headOffice' => 'required|string|max:255',
            'clientCategory' => 'required|string|max:255',
            'paymentTerms' => 'required|string',
            'paymentdetails' => 'required|string',
            //'paymentcycle' => 'required|string',
            'typeOfServices' => 'required|array|min:1',
            'clientScopeCafe' => 'required|array|min:1',
            'employeeNumber' => 'required|numeric|min:10',
            'typeServiceSuggestion' => 'max:150',
            'clientScopeSuggestion' => 'max:150',

            // 'breakfast' => 'nullable|numeric',
            // 'lunch' => 'nullable|numeric',
            // 'dinner' => 'nullable|numeric',
            // 'evening_snacks' => 'nullable|numeric',
            // 'others' => 'nullable|numeric'
        ]);
    }

    protected function saveUserInstance($name, $email, $username, $number, $address, $password) {
        $num = is_array($number) ? implode(", ", $this->remove_empty_array_values($number)) : $number;
        // dd($num);
        return User::create([
            'name' => $name,
            'email' => $email,
            'username' => $username,
            'contactNumber' => $num,
            'address' => $address,
            'password' => Hash::make('qwaszx123456'),
            'created_at' => date('Y-m-d H:i:s')
        ]);
    }

    protected function errorBag(array $errors) {
        $message = ["message" => implode(" ", $errors), "alert-type" => "error"];
        return $message;
    }

    protected function sendInvitationMail($type, $sendMailId, $foodcraftRole, $subject, $additional_data)
    {
        \Log::info("Send Invitation Mail");
        $existingData = array(
            'type' => $type,
            'subject' => $subject,
            'mailId' => $sendMailId,
            'role' => $foodcraftRole,
            'note' => 'This is a Test Email only..',
        );
        // dd($existingData);
        // dd($additional_data);
        $data = array_merge($existingData, $additional_data);
        // dd($data);
        $res = Mail::to($sendMailId)
                ->send(new SendMail($data));
    }

    public function register(Request $request)
    {
        // Use only one validation logic using this line (See reference: https://laravel.com/docs/6.x/validation#rule-required-if).
        // dd($request->all());
        //dd($request->client_agreement_end_date);
        try {
            $validate=[];
            if(strtolower($request->foodscraftRole) == "client"){
                $validate = $this->client_validation($request->all());
            }elseif(strtolower($request->foodscraftRole) == "vendor"){
                $validate = $this->vendor_validation($request->all());
            }elseif(strtolower($request->foodscraftRole) == "sitemarshal"){
                $validate = $this->marshal_validation($request->all());
            }
            // dd($validate, $request->foodscraftRole);
            // dd($validate->fails(), $validate->errors()->all());
            if (isset($validate) && $validate->fails()) {
                return back()->with($this->errorBag($validate->errors()->all()))->withInput();
            } else {
                $userInstance = $this->saveUserInstance($request->name, $request->email, $request->username, $request->contactNumber, $request->address, $request->password);
                // Mail Notification Implementation..
                $this->sendInvitationMail('usercreate', $request->email, $request->foodscraftRole, 'Role Invitation!', array('password' => $password = Hash::make('qwaszx123456')));
                Notifications::create([
                    'to' => $request->email,
                    'type' => 'usercreate',
                    'subject' => 'Role Invitation!',
                    'content' => $userInstance->id,
                    'created_at' => date('Y-m-d H:i:s'),
                ]);
                // $this->sendInvitationMail('usercreate', 'admin@gmail.com', 'admin', 'Role Invitation!');
                switch (strtolower($request->foodscraftRole)) {
                    case "sitemarshal":
                        // dd("You are SiteMarshal.");
                        $image = $request->pro_pic;
                        if(isset($image)){
                            $name = pathinfo($image->getClientOriginalName(), PATHINFO_FILENAME);
                            $extension = $image->getClientOriginalExtension();
                            $storageName = $name . '_' . rand(10, 10000) . '.' . $extension;
                            // dd($storageName, $image);
                            $store = $image->storeAs('public/documents/marshals/'.$userInstance->id.'/', $storageName);
                        }
                        //Resume
                        $resume = $request->resume;
                        if(isset($resume)){
                            $name1 = pathinfo($resume->getClientOriginalName(), PATHINFO_FILENAME);
                            $extension1 = $resume->getClientOriginalExtension();
                            $storageName1 = $name1 . '_' . rand(10, 10000) . '.' . $extension1;
                            // dd($storageName, $image);
                            $store1 = $resume->storeAs('public/documents/marshals/'.$userInstance->id.'/', $storageName1);
                        }
                        //GOV ID
                        $first_gov_id = $request->first_gov_id;
                        if(isset($first_gov_id)){
                            $name2 = pathinfo($first_gov_id->getClientOriginalName(), PATHINFO_FILENAME);
                            $extension2 = $first_gov_id->getClientOriginalExtension();
                            $storageName2 = $name2 . '_' . rand(10, 10000) . '.' . $extension2;
                            // dd($storageName, $image);
                            $store2 = $first_gov_id->storeAs('public/documents/marshals/'.$userInstance->id.'/', $storageName2);
                        }
                        $second_gov_id = $request->second_gov_id;
                        if(isset($second_gov_id)){
                            $name3 = pathinfo($second_gov_id->getClientOriginalName(), PATHINFO_FILENAME);
                            $extension3 = $second_gov_id->getClientOriginalExtension();
                            $storageName3 = $name3 . '_' . rand(10, 10000) . '.' . $extension3;
                            // dd($storageName, $image);
                            $store3 = $second_gov_id->storeAs('public/documents/marshals/'.$userInstance->id.'/', $storageName3);
                        }


                        Marshal::create([
                            'marshalId' => $userInstance->id,
                            'marshalname' => $userInstance->name,
                            'username' => $userInstance->username,
                            'designation' => $request->designation,
                            'employeeId' => $request->username,
                            'govId' => $request->govId,
                            'expInYrs' => $request->yearExp,
                            'siteAssigned' => $request->siteassigned,
                            'keyresponsibilities' => $request->keyresponsibilities,
                            'assignedSite' => isset($storageName) ? $storageName : 'default_foodscraft.png'
                        ]);
                        break;
                    case "vendor":
                        // dd("You are Vendor.");
                        Vendor::create([
                            'vendorId' => $userInstance->id,
                            'vendorname' => $userInstance->name,
                            'username' => $userInstance->username,
                            'contactName' => $request->contactName,
                            'companyRole' => $request->companyRole,
                            'employeeNumber' => $request->employeeNumber,
                            'yearExp' => $request->yearExp,
                            'kitchenArea' => $request->kitchenArea,
                            'mealCapacity' => $request->mealCapacity,
                            'companyType' => $request->companyType,
                            'vendorScope' => implode(", ", $request->vendorScope),
                            'auditRating' => $request->auditRating,
                            'cameraNumber' => $request->cameraNumber,
                            'cameraMegaPixel' => $request->cameraMegaPixel
                        ]);
                        break;
                    case "client":
                        // dd("You are Client.");
                        if(isset($request->clientDocuments)){
                            if(count($request->clientDocuments) > 0){
                                if(count($request->clientDocuments) > 5){
                                    return back()->with($this->errorBag(array("Maximum upload limit is 5.")));
                                }else{
                                    $this->clientAgreementDocuments($request->clientDocuments, $request->client_agreement_end_date, $userInstance->id, $userInstance->username);
                                }
                            }
                        }
                        Client::create([
                            'clientId' => $userInstance->id,
                            'clientname' => $userInstance->name,
                            'username' => $userInstance->username,
                            'contactName' => is_array($request->contactName) ? implode(", ", $this->remove_empty_array_values($request->contactName)) : $request->contactName,
                            'employeeNumber' => $request->employeeNumber,
                            'headOffice' => $request->headOffice,
                            'clientCategory' => $request->clientCategory,
                            'typeOfServices' => implode(", ", $request->typeOfServices),
                            'clientScopeCafe' => implode(", ", $request->clientScopeCafe),
                            'paymentTerms' => $request->paymentTerms,
                            'paymentdetails' => $request->paymentdetails,
                            //'paymentcycle' => $request->paymentcycle,
                            'typeServiceSuggestion' => $request->typeServiceSuggestion,
                            'clientScopeSuggestion' => $request->clientScopeSuggestion
                        ]);
                        MealRateList::updateOrCreate(
                            [
                                'client_id' => $userInstance->id,
                                'client_code' => $userInstance->username
                            ],
                            [
                                'breakfast1' => $request->type1['breakfast'],
                                'lunch1' => $request->type1['lunch'],
                                'dinner1' => $request->type1['dinner'],
                                'snacks1' => $request->type1['snacks'],
                                'others1' => $request->type1['others'],
                                'breakfast2' => $request->type2['breakfast'],
                                'lunch2' => $request->type2['lunch'],
                                'dinner2' => $request->type2['dinner'],
                                'snacks2' => $request->type2['snacks'],
                                'others2' => $request->type2['others'],
                                'breakfast3' => $request->type3['breakfast'],
                                'lunch3' => $request->type3['lunch'],
                                'dinner3' => $request->type3['dinner'],
                                'snacks3' => $request->type3['snacks'],
                                'others3' => $request->type3['others'],
                                'breakfast_from' => $request->breakfast_from,
                                'breakfast_to' => $request->breakfast_to,
                                'lunch_from' => $request->lunch_from,
                                'lunch_to' => $request->lunch_to,
                                'dinner_from' => $request->dinner_from,
                                'dinner_to' => $request->dinner_to,
                                'snacks_from' => $request->snacks_from,
                                'snacks_to' => $request->snacks_to,
                                'others_from' => $request->others_from,
                                'others_to' => $request->others_to,
                                // 'created_at' => date('Y-m-d H:i:s')
                            ]
                        );
                        break;
                    default:
                        dd("You are Nobody.");
                }
                $userInstance->assignRole(strtolower($request->foodscraftRole));
                return redirect('listAll/' . strtolower($request->foodscraftRole))->with(["message" => "Form Submitted Successfully", "alert-type" => "success"]);
            }
        } catch (Exception $e) {
            \Log::info($e);
            report($e);
            return false;
        }
    }

    protected function userInfo($id) {
        return User::where('id', $id)
            ->select('id', 'name', 'email', 'username', 'contactNumber', 'address')
            // ->first()->toArray();
            ->first();
    }

    protected function marshalDetails($user) {
        return Marshal::where([
            ['marshalId', '=', $user['id']],
            ['username', '=', $user['username']]
        ]);
    }

    protected function vendorDetails($user) {
        return Vendor::where([
            ['vendorId', '=', $user['id']],
            ['username', '=', $user['username']]
        ]);
    }

    protected function clientDetails($user) {
        return Client::where([
            ['clientId', '=', $user['id']],
            ['username', '=', $user['username']]
        ]);
    }

    protected function clientMealrateDetails($user) {
        return MealRateList::where([
            ['client_id', '=', $user['id']]
        ]);
    }

    public function deleteSpecificRole(int $id) {
        \Log::info($id);
        $user = $this->userInfo($id);
        $role['foodscraftRole'] = User::find($id)->getRoleNames()->toArray()[0];
        switch ($role['foodscraftRole']) {
            case "sitemarshal":
                $this->marshalDetails($user)->delete();
                break;
            case "vendor":
                $this->vendorDetails($user)->delete();
                break;
            case "client":
                $this->clientDetails($user)->delete();
                $this->clientMealrateDetails($user)->delete();
                break;
        }
        User::find($id)->removeRole($role['foodscraftRole']);
        User::find($id)->delete($id);
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function viewOrEditSpecificRole(string $type, int $id)
    {
        $user = $this->userInfo($id);
        if(isset($user)){
            $role['foodscraftRole'] = User::find($id)
                ->getRoleNames()
                // ->toArray()[0];
                ->first();
            $details = [];
            $listMapfirst = [];
            $listMapfirstdata = [];
            $listMapsecond = [];
            $listMapseconddata = [];

            switch ($role['foodscraftRole']) {
                case "sitemarshal":
                    $details = $this->marshalDetails($user)->first()->toArray();
                    // Fetch mapped vendor
                    $listMapfirst = MapRole::where('marshalId', $id)->select('vendorId')->distinct('vendorId')->get()->toArray();
                    foreach ($listMapfirst as $listMapfirstitem) {
                        $listMapfirstdata[] = User::join('vendors', 'users.id', '=', 'vendors.vendorId')
                                ->join('map_roles', 'map_roles.vendorId', '=', 'vendors.vendorId')
                                ->where('users.id', $listMapfirstitem['vendorId'])
                                ->select()->get()->toArray();
                    }
                    // Fetch mapped client
                    $listMapsecond = MapRole::where('marshalId', $id)->select('clientId')->distinct('clientId')->get()->toArray();
                    foreach ($listMapsecond as $listMapseconditem) {
                        $listMapseconddata[] = User::join('clients', 'users.id', '=', 'clients.clientId')
                                ->join('map_roles', 'map_roles.clientId', '=', 'clients.clientId')
                                ->where('users.id', $listMapseconditem['clientId'])
                                ->select()->get()->toArray();
                    }
                    break;
                case "vendor":
                    $details = $this->vendorDetails($user)->first()->toArray();
                    // Fetch mapped site marshall
                    $listMapfirst = MapRole::where('vendorId', $id)->select('marshalId')->distinct('marshalId')->get()->toArray();
                    foreach ($listMapfirst as $listMapfirstitem) {
                        $listMapfirstdata[] = User::join('marshals', 'users.id', '=', 'marshals.marshalId')
                                ->join('map_roles', 'map_roles.marshalId', '=', 'marshals.marshalId')
                                ->where('users.id', $listMapfirstitem['marshalId'])
                                ->select()->get()->toArray();
                    }
                    // Fetch mapped client
                    $listMapsecond = MapRole::where('vendorId', $id)->select('clientId')->distinct('clientId')->get()->toArray();
                    foreach ($listMapsecond as $listMapseconditem) {
                        $listMapseconddata[] = User::join('clients', 'users.id', '=', 'clients.clientId')
                                ->join('map_roles', 'map_roles.clientId', '=', 'clients.clientId')
                                ->where('users.id', $listMapseconditem['clientId'])
                                ->select()->get()->toArray();
                    }
                    break;
                case "client":
                    $details = $this->clientDetails($user)->first()->toArray();
                    $client_docs = ClientDocs::where('username', $details['username'])->first();
                    if($client_docs !== null){
                        $details = array_merge($details, $client_docs->toArray());
                    }
                    // Fetch mapped site marshall
                    $listMapfirst = MapRole::where('clientId', $id)->select('marshalId')->distinct('marshalId')->get()->toArray();
                    foreach ($listMapfirst as $listMapfirstitem) {
                        $listMapfirstdata[] = User::join('marshals', 'users.id', '=', 'marshals.marshalId')
                                ->join('map_roles', 'map_roles.marshalId', '=', 'marshals.marshalId')
                                ->where('users.id', $listMapfirstitem['marshalId'])
                                ->select()->get()->toArray();
                    }
                    // Fetch mapped vendor
                    $listMapsecond = MapRole::where('clientId', $id)->select('vendorId')->distinct('vendorId')->get()->toArray();
                    foreach ($listMapsecond as $listMapseconditem) {
                        $listMapseconddata[] = User::join('vendors', 'users.id', '=', 'vendors.vendorId')
                                ->join('map_roles', 'map_roles.vendorId', '=', 'vendors.vendorId')
                                ->where('users.id', $listMapseconditem['vendorId'])
                                ->select()->get()->toArray();
                    }
                    break;
            }
            $result = array_merge($user->toArray(), array_merge($details, $role));
            if ($type == "view" || $type == "edit") {
                $docs = [];
                if ($role['foodscraftRole'] == "sitemarshal") {
                    $docs['documents'] = MarshalDocs::where('marshalId', $result['marshalId'])->get()->toArray();
                } elseif ($role['foodscraftRole'] == "vendor") {
                    $docs['documents'] = VendorDocs::where('vendorId', $result['vendorId'])->get()->toArray();
                }
                $result = array_merge($result, $docs);
                if ($role['foodscraftRole'] == "client"){
                    $meal_rate_list = MealRateList::where([
                        'client_id' => $result['clientId'],
                        'client_code' => $result['username']
                    ])->first();
                    if(isset($meal_rate_list)){
                        $result = array_merge($result, $meal_rate_list->toArray());
                    }
                }
            }
            if($type == "view"){
                switch (strtolower($role['foodscraftRole'])){
                    case "sitemarshal":
                        return view("Admin::register/read/read_marshal", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
                    case "vendor":
                        return view("Admin::register/read/read_vendor", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
                    case "client":
                        return view("Admin::register/read/read_client", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
                }
            }else if($type == "edit"){
                switch (strtolower($role['foodscraftRole'])){
                    case "sitemarshal":
                        return view("Admin::register/edit/edit_marshal", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
                    case "vendor":
                        return view("Admin::register/edit/edit_vendor", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
                    case "client":
                        return view("Admin::register/edit/edit_client", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
                }
            }
            // return view("Admin::register", compact('result', 'type', 'listMapfirstdata', 'listMapseconddata'));
        }else{
            return back()->with(["message" => "User Not Found", "alert-type" => "warning"]);
        }
    }

    public function updateSpecificRole(Request $request) {
        $request->foodscraftRole = strtolower($request->foodscraftRole);
        // dd($request->all(), $request->foodscraftRole);
        $validate=[];
        if($request->foodscraftRole == "client"){
            $validate = $this->client_validation($request->all());
        }elseif($request->foodscraftRole == "vendor"){
            $validate = $this->vendor_validation($request->all());
        }elseif($request->foodscraftRole == "sitemarshal"){
            $validate = $this->marshal_validation($request->all());
        }
        $allErrors = $validate->errors()->all();
        if($validate->fails()){
            if(in_array("The password field is required.", $allErrors)){
                $pos = array_search("The password field is required.", $allErrors);
                unset($allErrors[$pos]);
            }
            if(in_array("The username has already been taken.", $allErrors)){
                $pos = array_search("The username has already been taken.", $allErrors);
                unset($allErrors[$pos]);
            }
            if(in_array("The email has already been taken.", $allErrors)){
                $pos = array_search("The email has already been taken.", $allErrors);
                unset($allErrors[$pos]);
            }
        }
        // dd($validate->fails(), $validate->errors()->all(), $request->foodscraftRole);
        if (isset($allErrors) && !empty($allErrors)) {
            return back()->with($this->errorBag($allErrors))->withInput($request->except(['password', 'email', 'username']));
        } else {
            User::where([
                'id' => $request->id,
                'username' => $request->username
            ])->update([
                'name' => $request->name,
                'email' => $request->email,
                'contactNumber' => is_array($request->contactNumber) ? implode(", ", $this->remove_empty_array_values($request->contactNumber)) : $request->contactNumber,
                'address' => $request->address,
            ]);
            switch ($request->foodscraftRole) {
                case "sitemarshal":
                    Marshal::where([
                        'marshalId' => $request->id,
                        'username' => $request->username
                    ])->update([
                        'designation' => $request->designation,
                        'employeeId' => $request->username,
                        'govId' => $request->govId,
                        'expInYrs' => $request->yearExp,
                        'siteAssigned' => $request->siteassigned,
                        'keyresponsibilities' => $request->keyresponsibilities,
                        'assignedSite' => $request->assignedsite
                    ]);
                    return redirect('listAll/sitemarshal')->with(["message" => "Role Updated Successfully", "alert-type" => "success"]);
                    break;
                case "vendor":
                    Vendor::where([
                        'vendorId' => $request->id,
                        'username' => $request->username
                    ])->update([
                        'contactName' => $request->contactName,
                        'companyRole' => $request->companyRole,
                        'employeeNumber' => $request->employeeNumber,
                        'yearExp' => $request->yearExp,
                        'kitchenArea' => $request->kitchenArea,
                        'mealCapacity' => $request->mealCapacity,
                        'companyType' => $request->companyType,
                        'vendorScope' => implode(", ", $request->vendorScope),
                        'auditRating' => $request->auditRating,
                        'cameraNumber' => $request->cameraNumber,
                        'cameraMegaPixel' => $request->cameraMegaPixel
                    ]);
                    return redirect('listAll/vendor')->with(["message" => "Role Updated Successfully", "alert-type" => "success"]);
                    break;
                case "client":
                    if(isset($request->clientDocuments)){
                        if(count($request->clientDocuments) > 0){
                            if(count($request->clientDocuments) > 5){
                                return back()->with($this->errorBag(array("Maximum upload limit is 5.")));
                            }else{
                                $this->clientAgreementDocuments($request->clientDocuments, $request->client_agreement_end_date, $userInstance->id, $userInstance->username);
                            }
                        }
                    }
                    Client::where([
                        'clientId' => $request->id,
                        'username' => $request->username
                    ])->update([
                        'contactName' => is_array($request->contactName) ? implode(", ", $this->remove_empty_array_values($request->contactName)) : $request->contactName,
                        'employeeNumber' => $request->employeeNumber,
                        'headOffice' => $request->headOffice,
                        'clientCategory' => $request->clientCategory,
                        'typeOfServices' => implode(", ", $request->typeOfServices),
                        'clientScopeCafe' => implode(", ", $request->clientScopeCafe),
                        'paymentTerms' => $request->paymentTerms
                    ]);
                    MealRateList::updateOrCreate(
                        [
                            'client_id' => $request->id,
                            'client_code' => $request->username
                        ],
                        [
                            'breakfast1' => $request->type1['breakfast'],
                            'lunch1' => $request->type1['lunch'],
                            'dinner1' => $request->type1['dinner'],
                            'snacks1' => $request->type1['snacks'],
                            'others1' => $request->type1['others'],
                            'breakfast2' => $request->type2['breakfast'],
                            'lunch2' => $request->type2['lunch'],
                            'dinner2' => $request->type2['dinner'],
                            'snacks2' => $request->type2['snacks'],
                            'others2' => $request->type2['others'],
                            'breakfast3' => $request->type3['breakfast'],
                            'lunch3' => $request->type3['lunch'],
                            'dinner3' => $request->type3['dinner'],
                            'snacks3' => $request->type3['snacks'],
                            'others3' => $request->type3['others'],
                            'breakfast_from' => $request->breakfast_from,
                            'breakfast_to' => $request->breakfast_to,
                            'lunch_from' => $request->lunch_from,
                            'lunch_to' => $request->lunch_to,
                            'dinner_from' => $request->dinner_from,
                            'dinner_to' => $request->dinner_to,
                            'snacks_from' => $request->snacks_from,
                            'snacks_to' => $request->snacks_to,
                            'others_from' => $request->others_from,
                            'others_to' => $request->others_to
                        ]
                    );
                    return redirect('listAll/client')->with(["message" => "Role Updated Successfully", "alert-type" => "success"]);
                    break;
            }
        }
    }

    public function giveMapDetails(Request $request, $roleType=null, $search=null)
    {
        if($request->ajax()){
            $usersWithRoles = User::role($roleType)
                ->where('users.name', 'LIKE', "%{$search}%")
                ->select('id', 'name', 'email', 'username', 'contactNumber', 'address')
                ->orderBy('id', 'DESC')
                ->paginate(20);
            foreach($usersWithRoles as $user){
                if($roleType == 'client'){
                    $contactPerson = Client::where('clientId', $user->id)->select('contactName')->first();
                    $user->contactPerson = $contactPerson->contactName;
                }elseif($roleType == 'vendor'){
                    $contactPerson = Vendor::where('vendorId', $user->id)->select('contactName')->first();
                    $user->contactPerson = $contactPerson->contactName;
                }
            }
            $rolesWithInfo = array($roleType => $usersWithRoles->toArray());
            // dd($rolesWithInfo);
            return Response($this->render_map_html($rolesWithInfo));
        }else{
            return view('Admin::map/create_map');
        }
    }

    protected function render_map_html($role)
    {
        // dd($role);
        $roles = [];
        $client = $vendor = $marshal = $output = "";
        foreach($role as $role_name => $role_detail){
            // dd($role_name, $role_detail);
            $roles['current_page'] = $role_detail['current_page'];
            $roles['prev_page_url'] = $role_detail['prev_page_url'];
            $roles['next_page_url'] = $role_detail['next_page_url'];
            $roles['last_page_url'] = $role_detail['last_page_url'];
            $roles['last_page'] = $role_detail['last_page'];
            $roles['total'] = $role_detail['total'];
            if($role_name == "client")
            {
                foreach ($role_detail['data'] as $key => $value) {
                    // dd($key, $value);
                    $label = "<label class='radio' onclick=" . '"' . "checkClients".
                    "({'id':".$value['id'].
                    ", 'name':". "'" .$value['name']. "'".
                    ", 'email':". "'" .$value['username']."'".
                    ", 'contactName':"."'".$value['contactPerson']."'".
                    ", 'contactNumber':"."'".$value['contactNumber']."'".
                    ", 'currentElement': this});" . '"' . "><input type='radio' name='clientValue' id='" . $value['username'] . "' value='" . $value['username'] . "' />" . "<span></span></label>";
                    // dd($label);
                    $output.='<tr>'.
                    '<td class="text-center">'.++$key.'</td>'.
                    '<td class="text-center">'.$value['name'].'</td>'.
                    '<td class="text-center">'.$value['username'].'</td>'.
                    '<td class="text-center">'.$value['contactPerson'].'</td>'.
                    '<td class="text-center">'.$value['contactNumber'].'</td>'.
                    '<td class="d-flex justify-content-center">'.$label.'</td>'.
                    '</tr>';
                }
            }
            elseif($role_name == "vendor")
            {
                foreach ($role_detail['data'] as $key => $value) {
                    // dd($key, $value);
                    $inp = "<input type='checkbox' class='inp-cbx position-fixed' id='".$value['username']."' value='".$value['username']."' name='vendorValue[".$value['id']."]' />";
                    $inp1 = "<center><select name='v_type[".$value['id']."]'><option value=''>Select Type</option><option value='1'>Companey Paid</option><option value='0'>Not Companey Paid</option> </select></center>";
                    
                    $label = "<label class='cbx'". "for='". $value['username'] ."'"."onclick=" . '"' . "checkVendors".
                    "({'id':".$value['id'].
                    ", 'name':". "'" .$value['name']. "'".
                    ", 'email':". "'" .$value['username']."'".
                    ", 'contactName':"."'".$value['contactPerson']."'".
                    ", 'contactNumber':"."'".$value['contactNumber']."'".
                    ", 'currentElement': this});" . '"' . "><span><svg width='12px' height='11px' viewBox='0 0 12 11'><polyline points='1 6.29411765 4.5 10 11 1'></polyline></svg></span></label>";
                    // dd($label);
                    $output.='<tr>'.
                    '<td class="text-center">'.++$key.'</td>'.
                    '<td class="text-center">'.$value['name'].'</td>'.
                    '<td class="text-center">'.$value['username'].'</td>'.
                    '<td class="text-center">'.$value['contactPerson'].'</td>'.
                    '<td class="text-center">'.$value['contactNumber'].'</td>'.
                      '<td class="text-center">'.$inp1.'</td>'.
                    '<td class="d-flex justify-content-center">'.$inp.$label.'</td>'.
                    '</tr>';
                }
            }
            elseif($role_name == "sitemarshal")
            {
                foreach ($role_detail['data'] as $key => $value) {
                    // dd($key, $value);
                    $inp = "<input type='checkbox' class='inp-cbx position-fixed' id='".$value['username']."' value='".$value['username']."' name='marshalValue[".$value['id']."]' />";
                    $label = "<label class='cbx'". "for='". $value['username'] ."'"."onclick=" . '"' . "checkMarshals".
                    "({'id':".$value['id'].
                    ", 'name':". "'" .$value['name']. "'".
                    ", 'email':". "'" .$value['username']."'".
                    ", 'contactName':"."'".$value['name']."'".
                    ", 'contactNumber':"."'".$value['contactNumber']."'".
                    ", 'currentElement': this});" . '"' . "><span><svg width='12px' height='11px' viewBox='0 0 12 11'><polyline points='1 6.29411765 4.5 10 11 1'></polyline></svg></span></label>";
                    // dd($label);
                    $output.='<tr>'.
                    '<td class="text-center">'.++$key.'</td>'.
                    '<td class="text-center">'.$value['name'].'</td>'.
                    '<td class="text-center">'.$value['username'].'</td>'.
                    '<td class="text-center">'.$value['contactNumber'].'</td>'.
                    '<td class="d-flex justify-content-center">'.$inp.$label.'</td>'.
                    '</tr>';
                }
            }
            // dd($roles);
        }
        $roles[$role_name] = $output;
        // dd($roles);
        return $roles;
    }

    public function takeMapDetails(Request $request)
    {
        
        //$s=37;
        // dd($request->v_type["$s"]);
        if (
            (isset($request->marshalValue) && !empty($request->marshalValue)) &&
            (isset($request->clientValue) && !empty($request->clientValue)) &&
            (isset($request->vendorValue) && !empty($request->vendorValue)) &&
            (isset($request->aggregation) && !empty($request->aggregation)) &&
            (isset($request->mealTime) && !empty($request->mealTime)) &&
            (isset($request->marTime) && !empty($request->marTime))
        ){
//            foreach ($request->aggregation as $vendorId => $aggregation) {
//                if ($aggregation == null) {
//                    return back()->with(["message" => "Invalid Arguments. Related Information Section's fields are mandatory to be filled.", "alert-type" => "warning"]);
//                }
//            }
//
//            foreach ($request->marTime as $vendorId => $marTime) {
//                if ($marTime == null) {
//                    return back()->with(["message" => "Invalid Arguments. Related Information Section's fields are mandatory to be filled.", "alert-type" => "warning"]);
//                }
//            }
//
//            foreach ($request->mealTime as $vendorId => $mealTime) {
//                if ($mealTime == null) {
//                    return back()->with(["message" => "Invalid Arguments. Related Information Section's fields are mandatory to be filled.", "alert-type" => "warning"]);
//                }
//            }
//
//            if ($request->commitment == null) {
//                return back()->with(["message" => "Invalid Arguments. Related Information Section's fields are mandatory to be filled.", "alert-type" => "warning"]);
//            }

            // Loop over here for its mapped request
            // $this->sendInvitationMail('newMapping', 'admin@gmail.com', 'admin', 'Relational Mapping!', array('Detail' => 'mapping is done.'));
            $mail_info['vendor'] = [];
            $mail_info['client'] = [];
            $mail_info['marshal'] = [];
            foreach($request->marshalValue as $marshalId => $marshalUsername){
                $marshal_mail_info = User::where('username', $marshalUsername)->select('id', 'name', 'username', 'email')->first()->toArray();
                array_push($mail_info['marshal'], $marshal_mail_info);
            }

            // foreach($request->clientValue as $clientId => $clientUsername){
            //     $client_mail_info = User::where('username', $clientUsername)->select('id', 'name', 'username', 'email')->first()->toArray();
            //     array_push($mail_info['client'], $client_mail_info);
            // }
            $client_mail_info = User::where('username', $request->clientValue)
                ->select('id', 'name', 'username', 'email')
                ->first()
                ->toArray();
            array_push($mail_info['client'], $client_mail_info);

            foreach($request->vendorValue as $vendorId => $vendorUsername){
                $vendor_mail_info = User::where('username', $vendorUsername)->select('id', 'name', 'username', 'email')->first()->toArray();
                array_push($mail_info['vendor'], $vendor_mail_info);
            }
            // dd($mail_info);
            foreach($mail_info as $role => $info){
                foreach($info as $value){
                    $this->sendInvitationMail('newMapping', $value['email'], $role, 'Relational Mapping!', $mail_info);
                    Notifications::create([
                        'to' => $value['email'],
                        'type' => 'newMapping',
                        'subject' => 'Relational Mapping!',
                        'content' => implode(", ", array($role, $value['id'])),
                        'created_at' => date('Y-m-d H:i:s'),
                    ]);
                }
            }

            foreach ($request->marshalValue as $marshalId => $marshalUsername) {
                // foreach ($request->clientValue as $clientId => $clientUsername) {
                    foreach ($request->vendorValue as $vendorId => $vendorUsername) {
                        
                        
                        $instance = MapRole::firstOrCreate(
                            [
                                'marshalId' => $marshalId,
                                'clientId' => $client_mail_info['id'],
                                'vendorId' => $vendorId,
                                'commitment' => $request->commitment,
                                'v_type' => (int)$request->v_type[$vendorId]
                            ]
                        );
                        
                        
                      
                        foreach ($request->aggregation as $venId => $aggregation) {
                            if ($venId == $vendorId) {
                                $updateValue = MapRole::updateOrCreate(
                                    [
                                        'marshalId' => $marshalId,
                                        'clientId' => $client_mail_info['id'],
                                        'vendorId' => $vendorId
                                    ],
                                    [
                                        'vendor_aggregation' => $aggregation,
                                    ]
                                );
                            }
                        }
                        foreach ($request->mealTime as $vendId => $mealTime) {
                            if ($vendId == $vendorId) {
                                $updateValue = MapRole::updateOrCreate(
                                    [
                                        'marshalId' => $marshalId,
                                        'clientId' => $client_mail_info['id'],
                                        'vendorId' => $vendorId
                                    ],
                                    [
                                        'meal_time' => $mealTime,
                                    ]
                                );
                            }
                        }
                        foreach ($request->marTime as $marId => $marTime) {
                            if ($marId == $marshalId) {
                                $updateValue = MapRole::updateOrCreate(
                                    [
                                        'marshalId' => $marshalId,
                                        'clientId' => $client_mail_info['id'],
                                        'vendorId' => $vendorId
                                    ],
                                    [
                                        'marshal_time' => $marTime,
                                    ]
                                );
                            }
                        }
                    }
                // }
            }
            // dd($instance->wasRecentlyCreated);
            if ($instance->wasRecentlyCreated) {
                return back()->with(["message" => "Roles Mapped Successfully", "alert-type" => "success"]);
            } else {
                return back()->with(["message" => "Roles Mapped Already", "alert-type" => "warning"]);
            }
        } else {
            return back()->with(["message" => "Invalid Arguments. Atleast pick one from each field.", "alert-type" => "warning"]);
        }
    }

    public function map_details(Request $request, $roleType, $search=null)
    {
        if(isset($roleType) && $request->ajax()){
            $roleList = "";
            $output = "";
            if($roleType == 'client'){
                $roleList = User::role(strtolower($roleType))
                    ->where('users.name', 'LIKE', "%{$search}%")
                    ->join('map_roles', 'users.id', '=', 'map_roles.clientId')
                    ->join('clients', function($join){
                        $join->on('users.id', '=', 'clients.clientId')
                            ->on('users.username', '=', 'clients.username');
                    })
                    ->select('users.id', 'users.name', 'users.username', 'users.contactNumber', 'clients.contactName');
            }
            elseif($roleType == 'vendor'){
                $roleList = User::role(strtolower($roleType))
                    ->where('users.name', 'LIKE', "%{$search}%")
                    ->join('map_roles', 'users.id', '=', 'map_roles.vendorId')
                    ->join('vendors', function($join){
                        $join->on('users.id', '=', 'vendors.vendorId')
                            ->on('users.username', '=', 'vendors.username');
                    })
                    ->select('users.id', 'users.name', 'users.username', 'users.contactNumber', 'vendors.contactName');
            }
            elseif($roleType == 'sitemarshal'){
                $roleList = User::role(strtolower($roleType))
                    ->where('users.name', 'LIKE', "%{$search}%")
                    ->join('map_roles', 'users.id', '=', 'map_roles.marshalId')
                    ->join('marshals', function($join){
                        $join->on('users.id', '=', 'marshals.marshalId')
                            ->on('users.username', '=', 'marshals.username');
                    })
                    ->select('users.id', 'users.name', 'users.username', 'users.contactNumber');
            }

            $roleList = $roleList->groupBy('username')->get();
            if($roleList){
                if($roleType == "client" || $roleType == "vendor"){
                    foreach ($roleList as $key => $role) {
                        $link = url('existingMap') . '/' . $roleType . '/' . $role->id;
                        $href="<a class='peterriver text-decoration-none text-white mx-4' href='".$link."'>Map Details</a>";
                        $output.='<tr>'.
                        '<td class="text-center">'.++$key.'</td>'.
                        '<td class="text-center">'.$role->name.'</td>'.
                        '<td class="text-center">'.$role->username.'</td>'.
                        '<td class="text-center">'.$role->contactName.'</td>'.
                        '<td class="text-center">'.$role->contactNumber.'</td>'.
                        '<td class="d-flex justify-content-center">'.$href.'</td>'.
                        '</tr>';
                    }
                }elseif($roleType == "sitemarshal"){
                    foreach ($roleList as $key => $role){
                        $link = url('existingMap') . '/' . $roleType . '/' . $role->id;
                        $href="<a class='peterriver text-decoration-none text-white mx-4' href='".$link."'>Map Details</a>";
                        $output.='<tr>'.
                        '<td class="text-center">'.++$key.'</td>'.
                        '<td class="text-center">'.$role->name.'</td>'.
                        '<td class="text-center">'.$role->username.'</td>'.
                        '<td class="text-center">'.$role->contactNumber.'</td>'.
                        '<td class="d-flex justify-content-center">'.$href.'</td>'.
                        '</tr>';
                    }
                }
            }
            return Response($output);
        }
    }

    public function existingMappingDetails(string $roleType = null, int $roleId = null)
    {
        if(isset($roleType) && $roleId == null){
            return view('Admin::map/mapped', compact('roleType'));
        }

        if ($roleId !== null) {
            $joinQueryId = ($roleType == "client" ? 'clientId' : ($roleType == "vendor" ? 'vendorId' : ($roleType == "sitemarshal" ? 'marshalId' : null)));
            $joinQuery = ($roleType == "client" ? array("vendorId" => 'map_roles.vendorId', "marshalId" => 'map_roles.marshalId') :
                            ($roleType == "vendor" ? array("clientId" => 'map_roles.clientId', "marshalId" => 'map_roles.marshalId') :
                                ($roleType == "sitemarshal" ? array("vendorId" => 'map_roles.vendorId', "clientId" => 'map_roles.clientId') : null)
                            )
                        );
            $listDetail = [];
            foreach ($joinQuery as $key => $value) {
                $list = MapRole::where($joinQueryId, $roleId)
                        ->join('users', $value, '=', 'users.id')
                        ->select('name', 'username', 'email', 'contactNumber', 'address', $key)
                        ->groupBy('username')
                        ->get()->toArray();
                $listDetail[$key] = $list;
            }
            return view('Admin::map/map_detail', compact('listDetail', 'roleType'));
        } else {
            return view('Admin::map/mapped');
        }
    }

    public function eventList(string $type, $eventId = null, $vendorId = null) {
        switch ($type) {
            case "noList":
                $noList = "No List";
                return view('Admin::event/event', compact('noList'));
                break;
            case "newList":
                $eventList = RolesEvent::where('status', 'waiting')
                    ->where('assigned_vendor', null)
                    ->join('users as u1', 'roles_events.client_id', '=', 'u1.id')
                    ->select('roles_events.*', 'u1.name as client_name', 'u1.username as client_username')
                    ->paginate(4);
                return view('Admin::event/new_event', compact('eventList', 'type'));
                break;
            case "pendingList":
                $eventList = RolesEvent::where('status', 'pending')
                    ->join('users as u1', 'roles_events.client_id', '=', 'u1.id')
                    ->join('users as u2', 'roles_events.assigned_vendor', '=', 'u2.id')
                    ->select('roles_events.*', 'u1.name as client_name', 'u1.username as client_username', 'u2.name as vendor_name', 'u2.username as vendor_username')
                    ->paginate(4);
                return view('Admin::event/pending_event', compact('eventList', 'type'));
                break;
            case "approvedList":
                $eventList = RolesEvent::where('status', 'approved')
                    ->join('users as u1', 'roles_events.client_id', '=', 'u1.id')
                    ->join('users as u2', 'roles_events.assigned_vendor', '=', 'u2.id')
                    ->select('roles_events.*', 'u1.name as client_name', 'u1.username as client_username', 'u2.name as vendor_name', 'u2.username as vendor_username')
                    ->paginate(4);
                return view('Admin::event/approved_event', compact('eventList', 'type'));
                break;
            case "declineList":
                $eventList = RolesEvent::where('status', 'decline')->select('id', 'eventDate', 'status', 'assignedVendor', 'clientName', 'typeOfEvent')->paginate(4);
                return view('Admin::event', compact('eventList', 'type'));
                break;
            case "assign":
                $event = RolesEvent::where('event_ticket', $eventId)->first();
                // dd($event);
                if(isset($event->settled_rate)){
                    return back();
                }else{
                    $vendorList = MapRole::where('clientId', $event->client_id)
                        ->join('users', 'map_roles.vendorId', '=', 'users.id')
                        ->select('name', 'username', 'vendorId')
                        ->groupBy('username')
                        ->get();
                    return view('Admin::event/event', compact('event', 'vendorList', 'type'));
                }
                break;
            case "remove":
                RolesEvent::where('event_ticket', $eventId)
                    ->where('assigned_vendor', $vendorId)
                    ->delete();
                return back()->with(["message" => "Event Nullified Successfully", "alert-type" => "success"]);
                break;
            case "view":
                $event = RolesEvent::where('event_ticket', $eventId)->where('assigned_vendor', $vendorId)->first();
                $vendorList = User::where('id', $vendorId)->first();
                // dd($vendorList);
                return view('Admin::event/event', compact('event', 'vendorList', 'type'));
                break;
            default:
                dd("No type", $type);
                break;
        }
    }

    public function updateEventByAssign(Request $request)
    {
        // dd($request->all());
        $validate = Validator::make($request->all(), [
            'existingVendor' => 'required',
            'settled' => 'required|numeric'
        ]);

        if ($validate->fails()) {
            return back()->with($this->errorBag($validate->errors()->all()));
        } else {
            $whichEvent = RolesEvent::where('event_ticket', (int) $request->ticket)->first();
            // dd($whichEvent);
            if (is_array($request->existingVendor)) {
                foreach($request->existingVendor as $vendor_id){
                    // NOTIFY VENDORS
                    $event_assigned = RolesEvent::firstOrCreate(
                        [
                            'event_ticket' => $whichEvent->event_ticket,
                            'assigned_vendor' => (int)$vendor_id
                        ],
                        [
                            'client_id' => $whichEvent->client_id,
                            'event_date' => $whichEvent->event_date,
                            'guest_number' => $whichEvent->guest_number,
                            'rate_per_plate' => $whichEvent->rate_per_plate,
                            'settled_rate' => $request->settled,
                            'decoration_needed' => $whichEvent->decoration_needed,
                            'type_of_event' => $whichEvent->type_of_event,
                            'status' => 'pending'
                        ]
                    );
                }
            }else{
                $whichEvent->update([
                    'status' => 'pending',
                    'assignedVendor' => (int)$request->existingVendor
                ]);
            }
            RolesEvent::where('event_ticket', (int) $request->ticket)
                ->where('assigned_vendor', null)->update(['assigned_vendor'=>1]);
            // else {
            //     $whichEvent->update([
            //         'status' => 'approved',
            //         'assignedVendor' => 0
            //     ]);
            // }
            return redirect('events/newList')->with(["message" => "Event Assigned Successfully", "alert-type" => "success"]);
        }
    }

    public function changeStatus(int $id)
    {
        // dd($id);
        $concern = RaiseConcern::where('id', $id)->first();
        $concern->status = 'Resolved';
        $concern->save();
        return $this->allConcerns();
    }

    public function concernMessageInput(Request $request)
    {
        \Log::info($request->all());
        try{
            $concern_msg = new ConcernMessage;
            $concern_msg->concern_id = $request->id;
            $concern_msg->status = $request->status;
            $concern_msg->sender = Auth::user()->username;
            $concern_msg->messages = $request->message;
            $concern_msg->save();
            return response()->json([
                'success' => 'Concern Message Saved Successfully!'
            ]);
        }
        catch(Exception $e){
            \Log::info($e);
        }
    }

    public function allConcerns() {
        // dd('All Concerns');
        $concerns = RaiseConcern::join('users as u1', 'raise_concerns.clientId', '=', 'u1.id')
            ->join('users as u2', 'raise_concerns.vendorEmail', '=', 'u2.email')
            ->join('map_roles as mprl', function($join){
                $join->on('u1.id', '=', 'mprl.clientId')
                ->on('u2.id', '=', 'mprl.vendorId');
            })
            ->join('users as u3', 'mprl.marshalId', '=', 'u3.id')
            ->select(
                    'raise_concerns.id', 'raise_concerns.clientId', 'raise_concerns.description', 'raise_concerns.vendorEmail', 'raise_concerns.status',
                    'u1.email as client_email', 'u1.name as client_name', 'u1.username as client_username',
                    'u2.email as vendor_email', 'u2.name as vendor_name', 'u2.username as vendor_username',
                    'u3.email as marshal_email', 'u3.name as marshal_name', 'u3.username as marshal_username'
                )
            ->get();
        return view('Admin::concern', compact('concerns'));
    }

    public function concernDetail(int $id)
    {
        // dd($id);
        $concern = RaiseConcern::where('raise_concerns.id', $id)
                        ->join('users as u1', 'raise_concerns.clientId', '=', 'u1.id')
                        ->join('users as u2', 'raise_concerns.vendorEmail', '=', 'u2.email')
                        ->join('map_roles as mprl', function($join){
                            $join->on('u1.id', '=', 'mprl.clientId')
                            ->on('u2.id', '=', 'mprl.vendorId');
                        })
                        ->join('users as u3', 'mprl.marshalId', '=', 'u3.id')
                        ->select(
                                'raise_concerns.id', 'raise_concerns.clientId', 'raise_concerns.description',
                                'raise_concerns.comment', 'raise_concerns.images', 'raise_concerns.videos',
                                'u1.username as client_username', 'u1.name as client_name',
                                'u2.username as vendor_username', 'u2.name as vendor_name',
                                'u3.username as marshal_username', 'u3.name as marshal_name'
                            )
                        ->first();
        $messages = ConcernMessage::where('concern_id', $id)
                        ->where('status', '!=', 'closed')
                        ->orderBy('created_at')->get();
        // dd("Messages: ", $messages, "Concern: ", $concern);
        return view('Admin::concern', compact('concern', 'messages'));
    }

    public function clientAgreementDocuments(array $documents, string $clientAgreementEndDate, int $clientId, string $clientUsername)
    {
      //dd("pp".$clientAgreementEndDate);
        $clientAgreementEndDate =  date("Y-m-d", strtotime($clientAgreementEndDate));
        $docArr = [];
        foreach($documents as $key => $files){
            $name = pathinfo($files->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = $files->getClientOriginalExtension();
            $name = str_replace(' ', '', $name);
            $storageName = $name . '_' . rand(10, 10000) . '.' . $extension;
            $store = $files->storeAs('public/documents/clients/'.$clientId.'/', $storageName);
            array_push($docArr, $storageName);
        }
        $save_documents = ClientDocs::create([
            'clientId' => $clientId,
            'username' => $clientUsername,
            'temp1' => implode(" ", $docArr),
            'client_agreement_end_date' => $clientAgreementEndDate,
        ]);
    }

    public function notifications()
    {
        $notifications = Notifications::where('subject', '!=', 'Raised Concern!')
            ->orderBy('created_at', 'desc')
            ->paginate(5);
        // dd($notifications);
        return view('Admin::notifications', compact('notifications'));
    }

    public function eventNotification(int $id)
    {
        // dd($id);
        $event = RolesEvent::where('id', $id)->first();
        $vendorList = MapRole::where('clientId', $event->client_id)
        ->join('users', 'map_roles.vendorId', '=', 'users.id')
        ->select('name', 'username', 'vendorId')
                    ->first();
        // dd($vendorList);
        $type = "view";
        return view('Admin::event/event', compact('event', 'vendorList', 'type'));
        // return view('Admin::eventNotification', compact('roleEvent', 'vendorList'));
    }

    public function common_icount_client_value(string $yes_or_no, $search=null)
    {
        $clients = Client::where('qr_code_status', $yes_or_no)
        ->join('users', 'clients.clientId', '=', 'users.id')
        ->where('users.name', 'LIKE', "%{$search}%")
        ->select(
            'users.id as client_id',
            'name as client_name',
            'users.username as client_code',
            'contactName as contact_person',
            'contactNumber as client_number'
        )
        ->groupBy('clients.username')
        ->orderBy('created_at', 'desc')
        ->paginate(4);

        return $clients;
    }

    public function new_qr_client_list(Request $request, $search=null)
    {
        if($request->ajax()){
            return $this->common_icount_client_value('no', $search);
        }
        return view('Admin::icount/new_qr_client_list');
    }

    public function old_qr_client_list(Request $request, $search=null)
    {
        if($request->ajax()){
            return $this->common_icount_client_value('yes', $search);
        }
        return view('Admin::icount/old_qr_client_list');
    }

    public function allDineInReport(Request $request, $search=null)
    {
        if($request->ajax()){
            return $this->common_icount_client_value('yes', $search);
        }
        return view('Admin::icount/allDineInReport');
    }

    public function saleDineInReportEmpWise(Request $request, $search=null)
    {
        if($request->ajax()){
            return $this->common_icount_client_value('yes', $search);
        }
        return view('Admin::icount/saleDineInReportEmpWise');
    }

    public function generate_qr(Request $request)
    {
        // dd($request->all());
        $client = $request->all();
        $last_qr_id = QRDetail::where('client_id', $request->client_id)
            ->orderBy('id', 'desc')
            ->select('qr_id')
            ->first();
        // dd(isset($last_qr_id));
        $last_qr_id = isset($last_qr_id) ? ++$last_qr_id->qr_id : 1;
        return view('Admin::icount/generate_qr', compact('client', 'last_qr_id'));
    }

    protected function qr_detail_generator($id, $client_id, $client_code, $meal_category, $qr_name)
    {
        $absolute_path = public_path() . '/' . "storage/upload/client" . '/' . $client_code . '/' . $qr_name;
        $relative_path = asset('public/storage/upload/client') . '/' . $client_code . '/' . $qr_name;
        $input = array("qr_id" => (int) $id, "client_code" => (string) $client_code, "client_id" => (int) $client_id);
        $sensitive_value = implode(', ', array_map(
            function ($v, $k) { return sprintf("%s='%s'", $k, $v); },
            $input,
            array_keys($input)
        ));
        QrCode::format('png')
            ->size(200)
            ->generate($sensitive_value, $absolute_path);
        QRDetail::create([
            'qr_id' => $id,
            'client_id' => $client_id,
            'meal_category' => $meal_category,
            'client_code' => $client_code,
            'qr_path' => $relative_path
        ]);
    }

    public function qr_code_generator(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'qr_code_limit' => 'required|numeric|min:1',
            'qr_code_type' => 'required|string|max:25',
        ]);
        // dd($validator->fails());
        if(isset($validator) && $validator->fails()){
            return back()->with($this->errorBag($validator->errors()->all()))->withInput();
        }else{
            $qr_created_or_not = Client::where('username', $request->client_code)->where('qr_code_status', 'no')->first();
            $this->add_directory(public_path() . '/' . "storage/upload/client" . '/' . $request->client_code);
            if(isset($qr_created_or_not)){
                for ($x = $request->qr_id; $x <= $request->qr_code_limit; $x++) {
                    $qr_name = $x . '_' . $request->client_code . '_' . $request->qr_code_type . '.png';
                    $this->qr_detail_generator($x, $request->client_id, $request->client_code, $request->qr_code_type, $qr_name);
                }
            }else{
                $increment = $request->qr_id;
                for ($x = 1; $x <= $request->qr_code_limit; $x++) {
//                    ++$increment;
                    $qr_name = $increment . '_' . $request->client_code . '_' . $request->qr_code_type . '.png';
                    $this->qr_detail_generator($increment, $request->client_id, $request->client_code, $request->qr_code_type, $qr_name);
                    ++$increment;
                }
            }
            // SWITCH VALUE TO yes IN Client's TABLE
            Client::where('clientId', $request->client_id)->update(['qr_code_status' => 'yes']);
            return redirect('ICount/I-count/success_qr_generate' . '/' . $request->client_code);
        }
    }

    public function success_qr_generate($client_code)
    {
        $all_qr_codes = QRDetail::where('client_code', $client_code)
            ->select('qr_path')->get();
        return view('Admin::icount/success_qr_generate', compact('all_qr_codes'))
            ->with("message", 'QR Codes are successfully generated. Please download your new generated qr as following. Create employees of '. $client_code .' client to assign them!');
    }

    public function client_all_qr_code(Request $request)
    {
      $client_code = $request->client_code;
        $all_qr_codes = QRDetail::where('client_code', $client_code)
            ->select('qr_path')->get();
        return view('Admin::icount/client_all_qr_code', compact('all_qr_codes'))
            ->with("message", 'QR Codes are successfully generated. Please download your new generated qr as following. Create employees of '. $client_code .' client to assign them!');
    }

    public function add_directory($directory)
    {
        if(!File::exists($directory)){
            File::makeDirectory($directory, 0777, true);
        }
    }

    public function assign_qr_view(Request $request)
    {
        // dd($request->all());
        $client = $request->all();
        $avail_qr_code = QRDetail::where('assigned_emp_id', null)->where('client_code', $request->client_code)->get();
        return view('Admin::icount/assign_qr', compact('client', 'avail_qr_code'));
    }

    public function give_qr_type_detail($qr_type=null, $client_code=null)
    {
        if(isset($qr_type)){
            $qr_codes = QRDetail::where('assigned_emp_id', null)
                ->where('client_code', $client_code)
                ->where('meal_category', $qr_type)
                ->get();
            return $qr_codes;
        }
    }

    public function assign_qr(Request $request)
    {
        // dd($request->all());
        $validate = Validator::make($request->all(), [
            'client_id' => 'required|numeric',
            'client_code' => 'required|string|max:150',
            'emp_name' => 'required|string|max:150',
            'emp_id' => 'required|numeric',
            'designation' => 'required|string|max:150'
        ]);
        if (isset($validate) && $validate->fails()) {
            return redirect('ICount/I-count/old_qr/client_list')->with($this->errorBag($validate->errors()->all()));
        } else {
            $checkExistingEmpId = ClientsEmp::where('emp_id', $request->emp_id)
                ->where('client_code', $request->client_code)
                ->get();
            $checkExistingEmpId = count($checkExistingEmpId);
            if ($checkExistingEmpId == 0){
              $client_emp_id = ClientsEmp::create([
                'client_id' => $request->client_id,
                'client_code' => $request->client_code,
                'emp_name' => $request->emp_name,
                'emp_id' => $request->emp_id,
                'designation' => $request->designation,
                'assign_qr_status' => isset($request->avail_qr_code) ? 'yes' : 'no',
                'emp_height' => $request->height,
                'emp_weight' => $request->weight
              ]);
            } else {
              return redirect('ICount/I-count/old_qr/client_list')->with($this->errorBag(array("Employee Id should be Numeric and Unique.")));
            }
            if(isset($request->avail_qr_code)){
                QRDetail::where('client_code', $request->client_code)
                    ->where('qr_id', $request->avail_qr_code)
                    ->update(['assigned_emp_id' => $client_emp_id->id]);
            }
            // 'avail_qr_code' => isset($request->avail_qr_code) ? $request->avail_qr_code : null
            return redirect('ICount/I-count/old_qr/client_list')->with(["message" => "Employee Created Successfully", "alert-type" => "success"]);
        }
    }

    public function client_emp_view_list(Request $request, $search=null)
    {
        //dd($request->all());
        $client_code = $request->client_code;
        $client = $request->all();
        $qr_type = isset($request->qr_type) && $request->qr_type == 'type4' ? true : false;
        // dd($client);
        if($request->ajax()){
            $qr_type = $request->qr_type;
            $data = ClientsEmp::where('clients_emps.client_id', $request->client_id)
                ->join('qr_code_details', function($join) use($client_code){
                    $join->on('clients_emps.id', '=', 'qr_code_details.assigned_emp_id')
                    ->on('clients_emps.client_code', '=', 'qr_code_details.client_code');
                })
                ->where('clients_emps.client_code', $client_code)
                ->where('clients_emps.emp_name', 'LIKE', "%{$search}%");
            if($qr_type){
                $data->where('qr_code_details.meal_category', 'type4');
            }
            $employees = $data->paginate(50);
            return $employees;
        }
        return view('Admin::icount/client_emp_view_list', compact('client', 'qr_type'));
    }

    //For Type 4 Assgin QR Code EMP
    public function client_emp_type4_view_list(Request $request, $search=null)
    {
        //dd($request->all());
        $client_code = $request->client_code;
        $client = $request->all();
        $qr_type = isset($request->qr_type) && $request->qr_type == 'type4' ? true : false;
        // dd($client);
        if($request->ajax()){
            $qr_type = $request->qr_type;
            $data = ClientsEmp::where('clients_emps.client_id', $request->client_id)
                ->join('qr_code_details', function($join) use($client_code){
                    $join->on('clients_emps.id', '=', 'qr_code_details.assigned_emp_id')
                    ->on('clients_emps.client_code', '=', 'qr_code_details.client_code');
                })
                ->where('clients_emps.client_code', $client_code)
                ->where('clients_emps.emp_name', 'LIKE', "%{$search}%");
            if($qr_type){
                $data->where('qr_code_details.meal_category', 'type4');
            }
            $employees = $data->paginate(50);
            return $employees;
        }
        return view('Admin::icount/client_emp_type4_view_list', compact('client', 'qr_type'));
    }

    public function client_emp_edit_list(Request $request)
    {
        // dd($request->all());
        $client = $request->all();
        $qr_detail = null;
        $client_emp = ClientsEmp::where('client_id', $request->client_id)
            ->where('id', $request->id)->first();
        if($client_emp->assign_qr_status == 'yes'){
            $qr_detail = QRDetail::where('client_code', $request->client_code)
                ->where('assigned_emp_id', $request->id)->first();
        }
        $avail_qr_code = QRDetail::where('assigned_emp_id', null)->where('client_code', $request->client_code)->get();
        return view('Admin::icount/client_emp_edit_list', compact('client_emp', 'qr_detail', 'avail_qr_code', 'client'));
    }
    public function client_emp_cal_report(Request $request)
    {
        //dd($request->all());
        // $client = $request->all();
        $client_emp = ClientsEmp::with('client')->where('client_id', $request->client_id)
            ->where('emp_id', $request->emp_id)->first();
//        echo "<pre>";
//        print_r($client_emp);
//        echo "</pre>";
//        exit;
        // if($client_emp->assign_qr_status == 'yes'){
        //     $qr_detail = QRDetail::where('client_code', $request->client_code)
        //         ->where('assigned_emp_id', $request->id)->first();
        // }
        // $avail_qr_code = QRDetail::where('assigned_emp_id', null)->where('client_code', $request->client_code)->get();
        // dd($client_emp->client);
        return view('Admin::icount/client_emp_cal_report', compact('client_emp'));
    }

    public function client_all_emp_cal_report(Request $request)
    {
        //dd($request->all());
        // $client = $request->all();
        $clientdata = Client::select('clientname', 'clientId')->where('clientId', $request->client_id)
            ->first();
//        echo "<pre>";
//        print_r($client_emp);
//        echo "</pre>";
//        exit;
        // if($client_emp->assign_qr_status == 'yes'){
        //     $qr_detail = QRDetail::where('client_code', $request->client_code)
        //         ->where('assigned_emp_id', $request->id)->first();
        // }
        // $avail_qr_code = QRDetail::where('assigned_emp_id', null)->where('client_code', $request->client_code)->get();
        // dd($client_emp->client);
        return view('Admin::icount/client_all_emp_cal_report', compact('clientdata'));
    }

    /**
     * Gets the emp cal report.
     *
     * @param      \Illuminate\Http\Request  $request  The request
     *
     * @return     <type>                    The emp cal report.
     */
    public function getEmpCalReport(Request $request){
//      print_r($request->all());
//      exit;
        $clientDataPP = Client::select('clientname', 'username')->where('clientId', $request->client_id)->first();
        $employee = ClientsEmp::with('client')->where('emp_id', $request->emp_id)->first();
        $report_data = Type4QrScanDetail::where('emp_id', $request->emp_database_id)
            ->where('client_id', $request->client_id)
            ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
           ->get();
//        print_r($report_data);
//        exit;
        foreach($report_data as $key => $data){
          $vendorid = isset($data->vendor_id) ? $data->vendor_id : '';
        }
        if(!empty($vendorid)){
          $vendorDataPP = User::select('name', 'username', 'address')->where('id', $vendorid)->first();
        }else{
            $vendor = MapRole::select('vendorId')->where('clientId', $request->client_id)->first();
            $vendorDataPP = User::select('name', 'username', 'address')->where('id', $vendor->vendorId)->first();
        }

        //$vendorid = isset($clientDataPP['username']) ? $clientDataPP['username'] : ''
//        echo $vendorid;
//        exit;
//        echo $vendorid = $report_data["vendor_id"];
//        exit;
//        echo "<pre>";
//        print_r($report_data);
//        echo "</pre>";
//        exit;

        $date_from = $request->date_from;
        $date_to = $request->date_to;
        // DB::table('type4_qr_scan_details')
        //     ->where('type4_qr_scan_details.emp_id', $request->emp_id)
        //     ->where('type4_qr_scan_details.client_id', $request->client_id)
        //     ->whereBetween('type4_qr_scan_details.created_at', [$request->date_from, $request->date_to])

        //     ->join('clients as c', 'type4_qr_scan_details.client_id', '=', 'c.clientId')
        //     ->join('clients_emps as ce', 'type4_qr_scan_details.emp_id', '=', 'ce.emp_id')
        //     // ->select('type4_qr_scan_details.*','c.*', 'ce.*')
        //     ->get();
        // dd($report_data);
        
        $bmivalue = $employee['emp_height']== null || $employee['emp_weight'] == null ? 'No Data': round($employee['emp_weight']/(($employee['emp_height']/100) *($employee['emp_height']/100)),2);
        $bmicategory = '';
        if($bmivalue == 'No Data'){
            $bmicategory = 'No Data';
        }
        else if ( $bmivalue < 18.5){
            $bmicategory = 'Under Weight';
        }
        else if ( $bmivalue >= 18.5 && $bmivalue <=24.9){
            $bmicategory = 'Normal Weight';
        }
        else if ( $bmivalue >= 25 && $bmivalue <=30){
            $bmicategory = 'Over Weight';
        }
        else if ( $bmivalue > 30){
            $bmicategory = 'Obese';
        }
        $bmi =$bmivalue . ' ('.$bmicategory.')';
        // dd($bmi);
        return view('Admin::icount/client_emp_cal_report_data', compact('report_data', 'employee', 'date_from', 'date_to', 'clientDataPP', 'vendorDataPP','bmi','bmivalue'));
    }

    public function client_emp_update_list(Request $request)
    {
        // dd($request->all());
        $validate = Validator::make($request->all(), [
            'client_id' => 'required|numeric',
            'client_code' => 'required|string|max:150',
            'emp_name' => 'required|string|max:150',
            'emp_id' => 'required|numeric',
            'designation' => 'required|string|max:150',
            // 'avail_qr_code' => 'required|numeric'
        ]);
        if (isset($validate) && $validate->fails()) {
            // dd($validate->errors());
            return redirect('ICount/I-count/old_qr/client_list')->with($this->errorBag($validate->errors()->all()));
        } else {
            // dd("Succeed");
            // if($request->assign_qr_status == "yes"){
            //     QRDetail::where('client_code', $request->client_code)
            //         ->where('assigned_emp_id', $request->client_emp_id)
            //         ->update(['assigned_emp_id' => null]);
            // }
            ClientsEmp::where('client_id', $request->client_id)
                ->where('id', $request->client_emp_id)
                ->update([
                    'emp_name' => $request->emp_name,
                    'emp_id' => $request->emp_id,
                    'designation' => $request->designation,
                    // 'assign_qr_status' => isset($request->avail_qr_code) ? 'no' : 'yes',
                    'emp_height' => $request->height,
                    'emp_weight' => $request->weight
                ]);
            // if(isset($request->avail_qr_code)){
            //     QRDetail::where('client_code', $request->client_code)
            //         ->where('qr_id', $request->avail_qr_code)
            //         ->update(['assigned_emp_id' => $request->client_emp_id]);
            //     ClientsEmp::where('client_id', $request->client_id)
            //         ->where('id', $request->client_emp_id)
            //         ->update(['assign_qr_status' => 'yes']);
            // }
            return redirect('ICount/I-count/old_qr/client_list')->with(["message" => "Employee Update Successfully", "alert-type" => "success"]);
        }
    }

    public function client_emp_delete_pre(Request $request, $search=null)
    {
        $delteempdata = $request->all();
        // dd($delteempdata);
        $employeesdeldata = DB::table('clients_emps')
            ->where('client_code', $request->client_code)
            ->where('id', $request->id)
            ->where('emp_id', $request->emp_id)
            ->where('client_id', $request->client_id)
            ->first();

        return view('Admin::icount/pre_emp_delete', compact('delteempdata', 'employeesdeldata'));
    }

    public function client_emp_delete(Request $request)
    {
        QRDetail::where('client_code', $request->client_code)
            ->where('assigned_emp_id', $request->id)
            ->update(['assigned_emp_id' => null]);
        ClientsEmp::where('client_id', $request->client_id)
            ->where('client_code', $request->client_code)
            ->where('id', $request->id)
            ->where('emp_id', $request->emp_id)
            ->delete();
        return redirect('ICount/I-count/old_qr/client_list')->with(["message" => "Employee Deleted Successfully", "alert-type" => "success"]);
    }

    public function reports(Request $request)
    {
        if(isset($request->sort_by)){
            $reports = Notifications::where('type', $request->sort_by)
                ->orderBy('created_at', 'desc')
                ->paginate(5);
        }else{
            $reports = Notifications::where('type', 'newConcern')
                ->orderBy('created_at', 'desc')
                ->paginate(5);
        }
        // dd($reports);
        return view('Admin::icount/reports', compact('reports'));
    }

    public function report_concern(int $id)
    {
        // dd($id);
        $concern = RaiseConcern::where('raise_concerns.id', $id)
            ->join('users as u1', 'raise_concerns.clientId', '=', 'u1.id')
            ->join('users as u2', 'raise_concerns.vendorEmail', '=', 'u2.email')
            ->join('map_roles as mprl', function($join){
                $join->on('u1.id', '=', 'mprl.clientId')
                ->on('u2.id', '=', 'mprl.vendorId');
            })
            ->join('users as u3', 'mprl.marshalId', '=', 'u3.id')
            ->select(
                    'raise_concerns.id', 'raise_concerns.clientId', 'raise_concerns.description',
                    'raise_concerns.comment', 'raise_concerns.images', 'raise_concerns.videos',
                    'u1.username as client_username', 'u1.name as client_name',
                    'u2.username as vendor_username', 'u2.name as vendor_name',
                    'u3.username as marshal_username', 'u3.name as marshal_name'
                )
            ->first();
        $messages = ConcernMessage::where('concern_id', $id)
                        ->where('status', '!=', 'closed')
                        ->orderBy('created_at')->get();
        return view('Admin::icount/report_concern', compact('concern', 'messages'));
    }

    public function invoice(Request $request, $search=null)
    {
        if($request->ajax()){
            $data = User::role('client')
                ->join('clients', 'users.id', '=', 'clients.clientId')
                ->where('users.name', 'LIKE', "%{$search}%")
                ->groupBy('clients.username')
                ->orderBy('created_at', 'desc')
                ->paginate(4);
            return $data;
        }
        return view('Admin::icount/invoice/invoice');
    }

    public function generate_invoice(Request $request)
    {
        // dd($request->all(), $request->isMethod('get'), $request->isMethod('post'));
        if($request->isMethod('get')){
          //dd("get");
            $client = (object) $request->all();
            return view('Admin::icount/invoice/generate_invoice', compact('client'));
            //return view('Admin::icount/invoice/get_client_invoice', compact('client'));
        }elseif($request->isMethod('post')){
            // dd("post");
            $from = "";
            $to = "";
            $dates = "";
            $data = MealCountDetail::where('client_code', $request->client_code);
            if($request->qr_type != 'all'){
                $data->where('qr_type', $request->qr_type);
            }
            if(!isset($request->date_from) && !isset($request->date_to)){
                $time = Carbon::now();
                $data->where('date', $time->toDateString())
                    ->orderBy('date', 'asc');
            }
            elseif(isset($request->date_from) && !isset($request->date_to)){
                $data->where('date', '>=', $request->date_from)
                    ->orderBy('date', 'asc');
            }
            elseif(!isset($request->date_from) && isset($request->date_to)){
                $data->where('date', '<=', $request->date_to)
                    ->orderBy('date', 'asc');
            }
            elseif(isset($request->date_from) && isset($request->date_to)){
                $data->whereBetween('date', [$request->date_from, $request->date_to])
                    ->orderBy('date', 'asc');
            }
            $dates = $data->get();
            $client_detail = (object) $request->all();
            if(!empty($request->date_from)) {
              $date_from = $request->date_from;
            }
            if(!empty($request->date_to)) {
              $date_to = $request->date_to;
            }
            // dd($dates, $client_detail);
            //return view('Admin::icount/invoice/generate_invoice', compact('dates', 'client_detail'));
            return view('Admin::icount/invoice/get_client_invoice', compact('dates', 'client_detail', 'date_from', 'date_to'));
        }
    }

    public function getClientEmployeesCal(Request $request){
        //dd($request->all());
        $clientDataPP = Client::select('clientname', 'username')->where('clientId', $request->client_id)->first();
        // $report_data = Type4QrScanDetail::where('client_id', $request->client_id)
        //         ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
        //         ->get();
        $report_data = Type4QrScanDetail::where('client_id', $request->client_id)
            ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
            ->select('id', 'client_id', 'vendor_id', 'qr_type', 'item_quantity',
                'emp_id', 'item_total_price',
                DB::raw("DATE(created_at) as date,sum(CASE
                    WHEN meal_type = 'breakfast' THEN item_approx_calorie*item_quantity
                    ELSE 0
                    END) as sum_breakfast, 
                    sum(CASE
                    WHEN meal_type = 'lunch' THEN item_approx_calorie*item_quantity
                    ELSE 0
                    END) as sum_lunch,
                    sum(CASE
                    WHEN meal_type = 'dinner' THEN item_approx_calorie*item_quantity
                    ELSE 0
                    END) as sum_dinner,
                    sum(CASE
                    WHEN meal_type = 'others' THEN item_approx_calorie*item_quantity
                    ELSE 0
                    END) as sum_others,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'breakfast' THEN concat(item_name,' (',item_quantity,' Quantity) (',item_approx_calorie,')')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as breakfast,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'lunch' THEN concat(item_name,' (',item_quantity,' Quantity) (',item_approx_calorie,')')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as lunch,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'dinner' THEN concat(item_name,' (',item_quantity,' Quantity) (',item_approx_calorie,')')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as dinner,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'others' THEN concat(item_name,' (',item_quantity,' Quantity) (',item_approx_calorie,')')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as others"))
                ->groupBY('emp_id')->orderBy('date')->get();
        // $report_data1 = DB::select(DB::raw("SELECT id, client_id, vendor_id, item_quantity,
        //             emp_id, DATE(created_at) as date, sum(CASE
        //             WHEN meal_type = 'breakfast' THEN item_approx_calorie*item_quantity
        //             ELSE 0
        //             END) as sum_breakfast, 
        //             sum(CASE
        //             WHEN meal_type = 'lunch' THEN item_approx_calorie*item_quantity
        //             ELSE 0
        //             END) as sum_lunch,
        //             sum(CASE
        //             WHEN meal_type = 'dinner' THEN item_approx_calorie*item_quantity
        //             ELSE 0
        //             END) as sum_dinner,
        //             sum(CASE
        //             WHEN meal_type = 'others' THEN item_approx_calorie*item_quantity
        //             ELSE 0
        //             END) as sum_others,
        //     GROUP_CONCAT(DISTINCT 
        //         @item_name := (CASE
        //             WHEN meal_type = 'breakfast' THEN item_name
        //             ELSE ''
        //             END
        //         ) SEPARATOR ', ') as breakfast,
        //     GROUP_CONCAT(DISTINCT 
        //         @item_name := (CASE
        //             WHEN meal_type = 'lunch' THEN item_name
        //             ELSE ''
        //             END
        //         ) SEPARATOR ', ') as lunch,
        //     GROUP_CONCAT(DISTINCT 
        //         @item_name := (CASE
        //             WHEN meal_type = 'dinner' THEN item_name
        //             ELSE ''
        //             END
        //         ) SEPARATOR ', ') as dinner,
        //     GROUP_CONCAT(DISTINCT 
        //         @item_name := (CASE
        //             WHEN meal_type = 'others' THEN item_name
        //             ELSE ''
        //             END
        //         ) SEPARATOR ', ') as others
                
        //     FROM type4_qr_scan_details WHERE client_id=$request->client_id 
        //     AND created_at BETWEEN '$request->date_from 00:00:00' AND '$request->date_to 23:59:59'
        //     GROUP BY emp_id ORDER BY created_at"));
        // dd($report_data1);
        // $rj_id = 6;
        // $rj = Type4QrScanDetail::select('item_name')->where('emp_id', $rj_id)
        //     ->whereBetween('created_at', ['2021-03-05'." 00:00:00", '2021-03-05'." 23:59:59"])
        //     ->where('meal_type', 'others')
        //     ->get();
        // dd($rj);
//        echo "<pre>";
//        print_r($report_data);
//        echo "</pre>";
//        exit;
        foreach($report_data as $key => $data){
          $vendorid = isset($data->vendor_id) ? $data->vendor_id : '';
        }
        if(!empty($vendorid)) {
          $vendorDataPP = User::select('name', 'username', 'address')->where('id', $vendorid)->first();
        }
        $date_from = $request->date_from;
        $date_to = $request->date_to;
        // dd($report_data);
        $client = Client::find($request->client_id);

        return view('Admin::icount/get_client_employees_cal_report', compact('client', 'report_data', 'clientDataPP', 'vendorDataPP', 'date_from', 'date_to'));
    }

    public function create_invoice(Request $request)
    {
        // dd($request->all());
        $invoice = Invoice::create([
            'client_code' => $request->client_code,
            'meal_rate_total' => $request->meal_rate_total,
            'meal_count_total' => $request->meal_count_total,
            'total' => $request->total,
            'date_from' => $request->date_from,
            'date_to' => $request->date_to,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        return redirect('ICount/I-count/invoice')->with(['message' => 'Invoice Generated', 'alert-type' => 'success']);
    }

    public function view_invoice(Request $request)
    {
        $invoices = Invoice::where('invoices.client_code', $request->client_code)
            ->join('users', 'invoices.client_code', '=', 'users.username')
            ->select('invoices.*', 'users.name as client_name')
            ->paginate(5);
        return view('Admin::icount/invoice/view_invoice', compact('invoices'));
    }

    public function export_invoice(Request $request)
    {
        $from = "";
        $to = "";
        $dates = "";
        if(!isset($request->date_from) && !isset($request->date_to)){
            $time = Carbon::now();
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', $time->toDateString())
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && !isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '>=', $request->date_from)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(!isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '<=', $request->date_to)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->whereBetween('date', [$request->date_from, $request->date_to])
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        $dates = $dates->select(
                            'users.name',
                            'meal_count_details.client_code',
                            'meal_count_details.meal_type',
                            'meal_count_details.meal_rate',
                            'meal_count_details.meal_count',
                            'meal_count_details.total',
                            'meal_count_details.date'
                        )
                    ->orderBy('date', 'asc')
                    ->get();
        $fetch_invoice = Invoice::where('id', $request->invoice_id)
            ->where('client_code', $request->client_code)
            ->first();
        $empty = ['', '', '', '', '', '', ''];
        $dates->push($empty);
        $invoice_info = ['', '', 'Total Sum', $fetch_invoice->meal_rate_total, $fetch_invoice->meal_count_total, $fetch_invoice->total, $fetch_invoice->created_at];
        $dates->push($invoice_info);
        // dd($request->all(), $dates, $fetch_invoice, $dates->toArray());
        $export = new InvoiceExport([$dates->toArray()]);
        // dd($export);
        $filename = $request->client_code . "_" . $request->date_from . '_' . $request->date_from . '.xlsx';
        return Excel::download($export, $filename);
    }



    //Generate Reports

    public function allreport(Request $request, $search=null)
    {
        if($request->ajax()){
            $data = User::role('client')
                ->join('clients', 'users.id', '=', 'clients.clientId')
                ->where('users.name', 'LIKE', "%{$search}%")
                ->groupBy('clients.username')
                ->orderBy('created_at', 'desc')
                ->paginate(4);
            return $data;
        }
        return view('Admin::icount/icount-report/allreport');
    }

    public function generate_report(Request $request)
    {
        // dd($request->all(), $request->isMethod('get'), $request->isMethod('post'));
        if($request->isMethod('get')){
          //dd("get");
            $client = (object) $request->all();
            return view('Admin::icount/icount-report/generate_report', compact('client'));
            //return view('Admin::icount/invoice/get_client_invoice', compact('client'));
        }elseif($request->isMethod('post')){
            // dd("post");
            $from = "";
            $to = "";
            $dates = "";
            //$data = MealCountDetail::where('client_code', $request->client_code);
            $data = QRScanDetail::where('client_code', $request->client_code);
            if($request->qr_type != 'all'){
                //$data->where('qr_type', $request->qr_type);
                $data->where('meal_category', $request->qr_type);
            }
            if(!isset($request->date_from) && !isset($request->date_to)){
                $time = Carbon::now();
                $data->where('date', $time->toDateString())
                    ->orderBy('date', 'asc');
            }
            elseif(isset($request->date_from) && !isset($request->date_to)){
                $data->where('date', '>=', $request->date_from)
                    ->orderBy('date', 'asc');
            }
            elseif(!isset($request->date_from) && isset($request->date_to)){
                $data->where('date', '<=', $request->date_to)
                    ->orderBy('date', 'asc');
            }
            elseif(isset($request->date_from) && isset($request->date_to)){
                $data->whereBetween('date', [$request->date_from, $request->date_to])
                    ->orderBy('date', 'asc');
            }
            $dates = $data->get();
            $client_detail = (object) $request->all();
            if(!empty($request->date_from)) {
              $date_from = $request->date_from;
            }
            if(!empty($request->date_to)) {
              $date_to = $request->date_to;
            }
            // dd($dates, $client_detail);
            //return view('Admin::icount/invoice/generate_invoice', compact('dates', 'client_detail'));
            return view('Admin::icount/icount-report/get_client_report', compact('dates', 'client_detail', 'date_from', 'date_to'));
        }
    }

    public function create_report(Request $request)
    {
        // dd($request->all());
        $invoice = Invoice::create([
            'client_code' => $request->client_code,
            'meal_rate_total' => $request->meal_rate_total,
            'meal_count_total' => $request->meal_count_total,
            'total' => $request->total,
            'date_from' => $request->date_from,
            'date_to' => $request->date_to,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        return redirect('ICount/I-count/allreport')->with(['message' => 'Report Generated', 'alert-type' => 'success']);
    }

    public function view_report(Request $request)
    {
        $invoices = Invoice::where('invoices.client_code', $request->client_code)
            ->join('users', 'invoices.client_code', '=', 'users.username')
            ->select('invoices.*', 'users.name as client_name')
            ->paginate(5);
        return view('Admin::icount/icount-report/view_report', compact('invoices'));
    }

    public function export_report(Request $request)
    {
        $from = "";
        $to = "";
        $dates = "";
        if(!isset($request->date_from) && !isset($request->date_to)){
            $time = Carbon::now();
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', $time->toDateString())
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && !isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '>=', $request->date_from)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(!isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '<=', $request->date_to)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->whereBetween('date', [$request->date_from, $request->date_to])
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        $dates = $dates->select(
                            'users.name',
                            'meal_count_details.client_code',
                            'meal_count_details.meal_type',
                            'meal_count_details.meal_rate',
                            'meal_count_details.meal_count',
                            'meal_count_details.total',
                            'meal_count_details.date'
                        )
                    ->orderBy('date', 'asc')
                    ->get();
        $fetch_invoice = Invoice::where('id', $request->invoice_id)
            ->where('client_code', $request->client_code)
            ->first();
        $empty = ['', '', '', '', '', '', ''];
        $dates->push($empty);
        $invoice_info = ['', '', 'Total Sum', '', $fetch_invoice->meal_count_total, $fetch_invoice->total, $fetch_invoice->created_at];
        $dates->push($invoice_info);
        // dd($request->all(), $dates, $fetch_invoice, $dates->toArray());
        $export = new ReportExport([$dates->toArray()]);
        // dd($export);
        $filename = $request->client_code . "_" . $request->date_from . '_' . $request->date_from . '.xlsx';
        return Excel::download($export, $filename);
    }


    //Generate Dining Sale Reports

    public function alldiningsalereport(Request $request, $search=null)
    {
        if($request->ajax()){
            $data = User::role('client')
                ->join('clients', 'users.id', '=', 'clients.clientId')
                ->where('users.name', 'LIKE', "%{$search}%")
                ->groupBy('clients.username')
                ->orderBy('created_at', 'desc')
                ->paginate(4);
            return $data;
        }
        return view('Admin::icount/icount-dining-sale-report/alldiningsalereport');
    }

    public function generate_diningsale_report(Request $request)
    {
        // dd($request->all(), $request->isMethod('get'), $request->isMethod('post'));
        if($request->isMethod('get')){
          //dd("get");
            $client = (object) $request->all();
            return view('Admin::icount/icount-dining-sale-report/generate_dining_report', compact('client'));
            //return view('Admin::icount/invoice/get_client_invoice', compact('client'));
        }elseif($request->isMethod('post')){
            //dd("post");
//            $from = "";
//            $to = "";
//            $dates = "";
//            $data = MealCountDetail::where('client_code', $request->client_code);
//            if($request->qr_type != 'all'){
//                $data->where('qr_type', $request->qr_type);
//            }
//            if(!isset($request->date_from) && !isset($request->date_to)){
//                $time = Carbon::now();
//                $data->where('date', $time->toDateString())
//                    ->orderBy('date', 'asc');
//            }
//            elseif(isset($request->date_from) && !isset($request->date_to)){
//                $data->where('date', '>=', $request->date_from)
//                    ->orderBy('date', 'asc');
//            }
//            elseif(!isset($request->date_from) && isset($request->date_to)){
//                $data->where('date', '<=', $request->date_to)
//                    ->orderBy('date', 'asc');
//            }
//            elseif(isset($request->date_from) && isset($request->date_to)){
//                $data->whereBetween('date', [$request->date_from, $request->date_to])
//                    ->orderBy('date', 'asc');
//            }
//            $dates = $data->get();
//            $client_detail = (object) $request->all();
//            if(!empty($request->date_from)) {
//              $date_from = $request->date_from;
//            }
//            if(!empty($request->date_to)) {
//              $date_to = $request->date_to;
//            }
            // dd($dates, $client_detail);
            //return view('Admin::icount/invoice/generate_invoice', compact('dates', 'client_detail'));
            //return view('Admin::icount/icount-dining-sale-report/get_dining_sale_report', compact('dates', 'client_detail', 'date_from', 'date_to'));

            $clientDataPP = Client::select('clientname', 'username')->where('clientId', $request->client_id)->first();
        // $report_data = Type4QrScanDetail::where('client_id', $request->client_id)
        //         ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
        //         ->get();
        $report_data = Type4QrScanDetail::where('client_id', $request->client_id)
            ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
            ->select('id', 'client_id', 'vendor_id', 'qr_type', 'item_quantity',
                'emp_id', 'item_total_price',
                DB::raw("DATE(created_at) as date,sum(CASE
                            WHEN meal_type = 'breakfast' THEN item_total_price
                            ELSE 0
                            END) as sum_price_breakfast, 
                            sum(CASE
                            WHEN meal_type = 'lunch' THEN item_total_price
                            ELSE 0
                            END) as sum_price_lunch,
                            sum(CASE
                            WHEN meal_type = 'dinner' THEN item_total_price
                            ELSE 0
                            END) as sum_price_dinner,
                            sum(CASE
                            WHEN meal_type = 'others' THEN item_total_price
                            ELSE 0
                            END) as sum_price_others,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'breakfast' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as breakfast,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'lunch' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as lunch,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'dinner' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as dinner,
                    GROUP_CONCAT(DISTINCT 
                        @item_name := (CASE
                            WHEN meal_type = 'others' THEN concat(item_name,' (',item_quantity,' Quantity)(',item_price,' Rs)')
                            ELSE ''
                            END
                        ) SEPARATOR ', ') as others"))
                ->groupBY('emp_id')->orderBy('date')->get();
//        echo "<pre>";
//        print_r($report_data);
//        echo "</pre>";
//        exit;
        foreach($report_data as $key => $data){
          $vendorid = isset($data->vendor_id) ? $data->vendor_id : '';
        }
        if(!empty($vendorid)) {
          $vendorDataPP = User::select('name', 'username', 'address')->where('id', $vendorid)->first();
        }
        $date_from = $request->date_from;
        $date_to = $request->date_to;
        // dd($report_data);
        $client = Client::find($request->client_id);

        return view('Admin::icount/icount-dining-sale-report/get_dining_sale_report', compact('client', 'report_data', 'clientDataPP', 'vendorDataPP', 'date_from', 'date_to'));

        }
    }

    public function create_diningsale_report(Request $request)
    {
        // dd($request->all());
        $invoice = Invoice::create([
            'client_code' => $request->client_code,
            'meal_rate_total' => $request->meal_rate_total,
            'meal_count_total' => $request->meal_count_total,
            'total' => $request->total,
            'date_from' => $request->date_from,
            'date_to' => $request->date_to,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        return redirect('ICount/icount-dining-sale-report/allreport')->with(['message' => 'Report Generated', 'alert-type' => 'success']);
    }

    public function view_diningsale_report(Request $request)
    {
        $invoices = Invoice::where('invoices.client_code', $request->client_code)
            ->join('users', 'invoices.client_code', '=', 'users.username')
            ->select('invoices.*', 'users.name as client_name')
            ->paginate(5);
        return view('Admin::icount/icount-dining-sale-report/view_report', compact('invoices'));
    }

    public function export_diningsale_report(Request $request)
    {
        $from = "";
        $to = "";
        $dates = "";
        if(!isset($request->date_from) && !isset($request->date_to)){
            $time = Carbon::now();
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', $time->toDateString())
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && !isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '>=', $request->date_from)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(!isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '<=', $request->date_to)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->whereBetween('date', [$request->date_from, $request->date_to])
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        $dates = $dates->select(
                            'users.name',
                            'meal_count_details.client_code',
                            'meal_count_details.meal_type',
                            'meal_count_details.meal_rate',
                            'meal_count_details.meal_count',
                            'meal_count_details.total',
                            'meal_count_details.date'
                        )
                    ->orderBy('date', 'asc')
                    ->get();
        $fetch_invoice = Invoice::where('id', $request->invoice_id)
            ->where('client_code', $request->client_code)
            ->first();
        $empty = ['', '', '', '', '', '', ''];
        $dates->push($empty);
        $invoice_info = ['', '', 'Total Sum', '', $fetch_invoice->meal_count_total, $fetch_invoice->total, $fetch_invoice->created_at];
        $dates->push($invoice_info);
        // dd($request->all(), $dates, $fetch_invoice, $dates->toArray());
        $export = new ReportExport([$dates->toArray()]);
        // dd($export);
        $filename = $request->client_code . "_" . $request->date_from . '_' . $request->date_from . '.xlsx';
        return Excel::download($export, $filename);
    }


    //See All Client QR Code:

    //Generate Dining Sale Reports

    public function allqrclient(Request $request, $search=null)
    {
        if($request->ajax()){
            $data = User::role('client')
                ->join('clients', 'users.id', '=', 'clients.clientId')
                ->where('users.name', 'LIKE', "%{$search}%")
                ->groupBy('clients.username')
                ->orderBy('created_at', 'desc')
                ->paginate(4);
            return $data;
        }
        return view('Admin::icount/icount-allclient-qrcode/allclientqrcode');
    }


    //Start Cron Functions:

    //Client Agreement End Date Notification Cron Function
    public function dateDiffInDays($currentDate, $client_agreement_end_date) {
      // Calculating the difference in timestamps
      $diff = strtotime($client_agreement_end_date) - strtotime($currentDate);

      // 1 day = 24 hours
      // 24 * 60 * 60 = 86400 seconds
      return abs(round($diff / 86400));
    }

    //Send Email Process
    protected function sendExpiryNotificationMail($type, $fkAdminEmailID, $clintEmailID, $subject, $additional_data)
    {
      $existingData = array(
          'type' => $type,
          'subject' => $subject,
          'mailId' => $fkAdminEmailID,
          'ccmailId' => $clintEmailID,
          'note' => 'This is a Test Email only..',
      );
      $data = array_merge($existingData, $additional_data);
      $res = Mail::to($fkAdminEmailID)
              //->cc(['name1@domain.com','name2@domain.com'])
              ->cc($clintEmailID)
              ->send(new SendMail($data));
      //\Log::info("Send Client Agreement Expiry Mail");
    }

    //Client Documnet Expiry cron notification function
    public function clientAgreementEndNotify() {
      //dd('Pradeep clientAgreementEndNotify');
      $clients = ClientDocs::distinct('clientId')
              ->select('clientId', 'client_agreement_end_date')
              ->get();
      foreach($clients as $client){
        $clientId = $client['clientId'];
        $client_agreement_end_date = $client['client_agreement_end_date'];
        if(isset($client_agreement_end_date) && !empty($client_agreement_end_date)){
          $currentDate = date('Y-m-d');
          if($currentDate > $client_agreement_end_date){
            echo "Already Expired!!";
          } else {
            $diffdays = $this->dateDiffInDays($currentDate, $client_agreement_end_date);
            if($diffdays<=15){

              $additional_data = array();

              //Fetch FoodsKraft Admin Email
              $fkAdminData = DB::table('model_has_roles')
                              ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                              ->select('users.email')
                              ->first();
              $fkAdminEmailID = $fkAdminData->email;

              //Fetch Client Email
              $clientData = DB::table('users')
                      ->join('clients', 'users.id', '=', 'clients.clientId')
                      ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'clients.contactName', 'clients.headOffice')
                      ->where('users.id', '=', $clientId)
                      ->first();
              $clintEmailID = $clientData->email;

              $mail_info['client'] = [];
              array_push($mail_info['client'], $clientData);

              //Send Notification Email
              $this->sendExpiryNotificationMail('expireClientDoc', $fkAdminEmailID, $clintEmailID, 'Client Agreement Expiry Notification!', $mail_info);


            } else {
              echo "It is ok for now!!";
              echo "<br/>";
            }
          }
        }
      }

//      echo "<pre>";
//      print_r($clients);
//      echo "</pre>";
//      exit;

    }

    //Vendor Documnet Expiry cron notification function
    public function vendorDocEndNotify() {
      $currentDate = date('Y-m-d');
      $vendors = VendorDocs::distinct('vendorId')
              ->select('vendorId', 'fssai_expiry_date', 'gst_expiry_date', 'pancard_expiry_date', 'cr_expiry_date', 'pf_expiry_date', 'labourLicense_expiry_date', 'workerHealth_expiry_date', 'foodTestReport_expiry_date', 'waterTestReport_expiry_date', 'pestControlReport_expiry_date', 'kitchenAuditReport_expiry_date', 'policeVerificationReport_expiry_date')
              ->get();

      foreach($vendors as $vendor){
        $vendorId = $vendor['vendorId'];
        $fssai_expiry_date = $vendor['fssai_expiry_date'];
        $gst_expiry_date = $vendor['gst_expiry_date'];
        $pancard_expiry_date = $vendor['pancard_expiry_date'];
        $cr_expiry_date = $vendor['cr_expiry_date'];
        $pf_expiry_date = $vendor['pf_expiry_date'];
        $labourLicense_expiry_date = $vendor['labourLicense_expiry_date'];
        $workerHealth_expiry_date = $vendor['workerHealth_expiry_date'];
        $foodTestReport_expiry_date = $vendor['foodTestReport_expiry_date'];
        $waterTestReport_expiry_date = $vendor['waterTestReport_expiry_date'];
        $pestControlReport_expiry_date = $vendor['pestControlReport_expiry_date'];
        $kitchenAuditReport_expiry_date = $vendor['kitchenAuditReport_expiry_date'];
        $policeVerificationReport_expiry_date = $vendor['policeVerificationReport_expiry_date'];

        if(isset($fssai_expiry_date) && !empty($fssai_expiry_date)){
          //echo "pradeep1";
          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "FSSAI Document";
          $diffdays = $this->dateDiffInDays($currentDate, $fssai_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($gst_expiry_date) && !empty($gst_expiry_date)){
          //echo "pradeep2";
          //$gst_expiry_date =  date("Y-m-d", strtotime($gst_expiry_date));
          $vendorDocumentName['docName'] = "GST Document";
          $diffdays = $this->dateDiffInDays($currentDate, $gst_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($pancard_expiry_date) && !empty($pancard_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Pan Card Document";
          $diffdays = $this->dateDiffInDays($currentDate, $pancard_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($cr_expiry_date) && !empty($cr_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Company Registration Document";
          $diffdays = $this->dateDiffInDays($currentDate, $cr_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($pf_expiry_date) && !empty($pf_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "PF Document";
          $diffdays = $this->dateDiffInDays($currentDate, $pf_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($labourLicense_expiry_date) && !empty($labourLicense_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Labour License Document";
          $diffdays = $this->dateDiffInDays($currentDate, $labourLicense_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($workerHealth_expiry_date) && !empty($workerHealth_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Worker Health";
          $diffdays = $this->dateDiffInDays($currentDate, $workerHealth_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($foodTestReport_expiry_date) && !empty($foodTestReport_expiry_date)){

          //$foodTestReport_expiry_date =  date("Y-m-d", strtotime($foodTestReport_expiry_date));
          $vendorDocumentName['docName'] = "Food Test Report";
          $diffdays = $this->dateDiffInDays($currentDate, $foodTestReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($waterTestReport_expiry_date) && !empty($waterTestReport_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Water Test Report";
          $diffdays = $this->dateDiffInDays($currentDate, $waterTestReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($pestControlReport_expiry_date) && !empty($pestControlReport_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Pest Control Report";
          $diffdays = $this->dateDiffInDays($currentDate, $pestControlReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($kitchenAuditReport_expiry_date) && !empty($kitchenAuditReport_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Kitchen Audit Report";
          $diffdays = $this->dateDiffInDays($currentDate, $kitchenAuditReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
        if(isset($policeVerificationReport_expiry_date) && !empty($policeVerificationReport_expiry_date)){

          //$fssai_expiry_date =  date("Y-m-d", strtotime($fssai_expiry_date));
          $vendorDocumentName['docName'] = "Police Verification Report";
          $diffdays = $this->dateDiffInDays($currentDate, $policeVerificationReport_expiry_date);
          if($diffdays<=15){
            //Fetch FoodsKraft Admin Email
            $fkAdminData = DB::table('model_has_roles')
                            ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                            ->select('users.email')
                            ->first();
            $fkAdminEmailID = $fkAdminData->email;

            //Fetch Vendor Email
            $vendorData = DB::table('users')
                    ->join('vendors', 'users.id', '=', 'vendors.vendorId')
                    ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'users.address', 'vendors.contactName')
                    ->where('users.id', '=', $vendorId)
                    ->first();
            $vendorEmailID = $vendorData->email;

            $mail_info['vendor'] = [];
            array_push($mail_info['vendor'], $vendorData);

            $mail_info['vendorDocumnetName'] = [];
            array_push($mail_info['vendorDocumnetName'], $vendorDocumentName);

//            echo "<pre>";
//            print_r($mail_info);
//            echo "</pre>";
//            exit;

            //Send Notification Email
            $this->sendExpiryNotificationMail('expireVendorDoc', $fkAdminEmailID, $vendorEmailID, 'Vendor Document Expiry Notification!', $mail_info);

          }
        }
//        else {
//          echo "It is ok for now!!";
//          echo "<br/>";
//        }
      }
    }


  //Generate Dinning Reports

    public function alldiningreport(Request $request, $search=null)
    {
        if($request->ajax()){
            $data = User::role('client')
                ->join('clients', 'users.id', '=', 'clients.clientId')
                ->where('users.name', 'LIKE', "%{$search}%")
                ->groupBy('clients.username')
                ->orderBy('created_at', 'desc')
                ->paginate(4);
            return $data;
        }
        return view('Admin::icount/icount-dining-report/allreport');
    }

    public function dining_generate_report(Request $request)
    {
        // dd($request->all(), $request->isMethod('get'), $request->isMethod('post'));
        if($request->isMethod('get')){
            $client = (object) $request->all();
            return view('Admin::icount/icount-report/generate_report', compact('client'));
        }elseif($request->isMethod('post')){
            // dd("post");
            $from = "";
            $to = "";
            $dates = "";
            if(!isset($request->date_from) && !isset($request->date_to)){
                $time = Carbon::now();
                $dates = MealCountDetail::where('client_code', $request->client_code)
                    ->where('date', $time->toDateString())
                    ->orderBy('date', 'asc')
                    ->get();
            }
            elseif(isset($request->date_from) && !isset($request->date_to)){
                $dates = MealCountDetail::where('client_code', $request->client_code)
                    ->where('date', '>=', $request->date_from)
                    ->orderBy('date', 'asc')
                    ->get();
            }
            elseif(!isset($request->date_from) && isset($request->date_to)){
                $dates = MealCountDetail::where('client_code', $request->client_code)
                    ->where('date', '<=', $request->date_to)
                    ->orderBy('date', 'asc')
                    ->get();
            }
            elseif(isset($request->date_from) && isset($request->date_to)){
                $dates = MealCountDetail::where('client_code', $request->client_code)
                    ->whereBetween('date', [$request->date_from, $request->date_to])
                    ->orderBy('date', 'asc')
                    ->get();
            }
            $client_detail = (object) $request->all();
            // dd($dates, $client_detail);
            return view('Admin::icount/icount-report/generate_report', compact('dates', 'client_detail'));
        }
    }

    public function dining_create_report(Request $request)
    {
        // dd($request->all());
        $invoice = Invoice::create([
            'client_code' => $request->client_code,
            'meal_rate_total' => $request->meal_rate_total,
            'meal_count_total' => $request->meal_count_total,
            'total' => $request->total,
            'date_from' => $request->date_from,
            'date_to' => $request->date_to,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        return redirect('ICount/I-count/allreport')->with(['message' => 'Report Generated', 'alert-type' => 'success']);
    }

    public function dining_view_report(Request $request)
    {
        $invoices = Invoice::where('invoices.client_code', $request->client_code)
            ->join('users', 'invoices.client_code', '=', 'users.username')
            ->select('invoices.*', 'users.name as client_name')
            ->paginate(5);
        return view('Admin::icount/icount-report/view_report', compact('invoices'));
    }

    public function dining_export_report(Request $request)
    {
        $from = "";
        $to = "";
        $dates = "";
        if(!isset($request->date_from) && !isset($request->date_to)){
            $time = Carbon::now();
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', $time->toDateString())
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && !isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '>=', $request->date_from)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(!isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->where('date', '<=', $request->date_to)
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        elseif(isset($request->date_from) && isset($request->date_to)){
            $dates = MealCountDetail::where('client_code', $request->client_code)
                ->whereBetween('date', [$request->date_from, $request->date_to])
                ->join('users', 'meal_count_details.client_code', '=', 'users.username');
        }
        $dates = $dates->select(
                            'users.name',
                            'meal_count_details.client_code',
                            'meal_count_details.meal_type',
                            'meal_count_details.meal_rate',
                            'meal_count_details.meal_count',
                            'meal_count_details.total',
                            'meal_count_details.date'
                        )
                    ->orderBy('date', 'asc')
                    ->get();
        $fetch_invoice = Invoice::where('id', $request->invoice_id)
            ->where('client_code', $request->client_code)
            ->first();
        $empty = ['', '', '', '', '', '', ''];
        $dates->push($empty);
        $invoice_info = ['', '', 'Total Sum', '', $fetch_invoice->meal_count_total, $fetch_invoice->total, $fetch_invoice->created_at];
        $dates->push($invoice_info);
        // dd($request->all(), $dates, $fetch_invoice, $dates->toArray());
        $export = new ReportExport([$dates->toArray()]);
        // dd($export);
        $filename = $request->client_code . "_" . $request->date_from . '_' . $request->date_from . '.xlsx';
        return Excel::download($export, $filename);
    }

    public function adminAIFeedsAllClient(Request $request, $type, $search=null){
      if($request->ajax()){
            // sleep(1);
            $data = $this->roles($type, $search);
            return $data;
        }
        return view('Admin::aiFeedClientList', compact('type'));
    }

    public function viewAIFeedVendor(string $type, int $id){
        //dd("View Vendor");
        $client = DB::table('clients')->where('clientId',$id)->first();
        $user = DB::table('users')
                  ->join('map_roles', 'map_roles.clientId', '=', 'users.id')
                  ->select('map_roles.vendorId')
                  ->get();
          $i=0;
          $userVendor=array();
          while($i<count($user)){
              $userVendor=(array)$user[$i];
              $id= $userVendor['vendorId'];
              $userVendor = ModelsVendor::where('vendorId',$id)
                          ->select('id','vendorId','vendorName','contactName', 'cameraNumber')
                          ->get();

              $vendorDetails[$i] = $userVendor[0];
              $i++;
          }
        return view('Admin::aiFeedVendorList', compact('vendorDetails','client'));

    }

    public function viewAIVendorCameras(int $id){
        $vendor = DB::table('vendors')
                    ->where('vendorId',$id)->first();
        $cameras = VendorCameras::where('vendorId',$id)
            ->get();
        return view('Admin::aiVendorCameraList',compact('cameras','vendor'));
    }

    public function viewAIFeedsCameras(string $id){
        $feeds = AIFeed::where('cameraId',$id)
                    ->orderByDesc('id')
                    ->get();
        return view('Admin::aifeedsview',compact('feeds'));
    }

    //Employee List of Specfic client having type 4 QR Code
    public function empClientSaleReport(Request $request, $search=null)
    {
        //dd($request->all());
        $client_code = $request->client_code;
        $client = $request->all();
        $qr_type = isset($request->qr_type) && $request->qr_type == 'type4' ? true : false;
        // dd($client);
        if($request->ajax()){
            $qr_type = $request->qr_type;
            $data = ClientsEmp::where('clients_emps.client_id', $request->client_id)
                ->join('qr_code_details', function($join) use($client_code){
                    $join->on('clients_emps.id', '=', 'qr_code_details.assigned_emp_id')
                    ->on('clients_emps.client_code', '=', 'qr_code_details.client_code');
                })
                ->where('clients_emps.client_code', $client_code)
                ->where('clients_emps.emp_name', 'LIKE', "%{$search}%");
            if($qr_type){
                $data->where('qr_code_details.meal_category', 'type4');
            }
            $employees = $data->paginate(50);
            return $employees;
        }
        return view('Admin::icount/empClientSaleReport', compact('client', 'qr_type'));
    }

    //Clent Employee Sale Report
    public function client_emp_sale_report(Request $request)
    {
      $client_emp = ClientsEmp::with('client')->where('client_id', $request->client_id)
          ->where('emp_id', $request->emp_id)->first();
      return view('Admin::icount/client_emp_sale_report', compact('client_emp'));
    }

    //Generate EMP Sale Report
    public function generate_emp_diningsale_report(Request $request)
    {
        // dd($request->all(), $request->isMethod('get'), $request->isMethod('post'));
        if($request->isMethod('get')){
            $client = (object) $request->all();
            return view('Admin::icount/icount-dining-sale-report/generate_dining_report', compact('client'));
        }elseif($request->isMethod('post')){
          //dd($request->all());
           $clientDataPP = Client::select('clientname', 'username')->where('clientId', $request->client_id)->first();
        $report_data = Type4QrScanDetail::where('client_id', $request->client_id)
                ->where('emp_id', $request->emp_database_id)
                ->whereBetween('created_at', [$request->date_from." 00:00:00", $request->date_to." 23:59:59"])
                ->get();
//        echo "<pre>";
//        print_r($report_data);
//        echo "</pre>";
//        exit;
        foreach($report_data as $key => $data){
          $vendorid = isset($data->vendor_id) ? $data->vendor_id : '';
        }
        if(!empty($vendorid)) {
          $vendorDataPP = User::select('name', 'username', 'address')->where('id', $vendorid)->first();
        }
        $date_from = $request->date_from;
        $date_to = $request->date_to;
        $empNameSale = $request->client_contact_name;
        $client = Client::find($request->client_id);

        return view('Admin::icount/icount-dining-sale-report/get_emp_dining_sale_report', compact('client', 'report_data', 'clientDataPP', 'vendorDataPP', 'date_from', 'date_to', 'empNameSale'));

        }
    }

}

//    protected function make_img_of_text($qr_id, $client_code)
//     {
//         $text = $qr_id . '_' . $client_code;
//         // $img = Image::make(public_path('webImages/white_bg.jpg'));
//         $img = Image::canvas(200, 200)->fill('rgba(255,255,255, 0.5)');
//         $img->resize(200, 200);
//         $img->text($text, 100, 100, function($font){
//             $font->file(public_path('fontStyles/red_rose/RedRose-Bold.ttf'));
//             $font->size(27);
//             $font->color('#445160');
//             $font->align('center');
//             $font->valign('bottom');
//             $font->angle(0);
//         });
//         $image = $img->save(public_path('storage/upload/client' . '/' . $text . '.png'));
//         return $text;
//     }

//     protected function qr_detail_generator($id, $client_id, $client_code, $qr_name)
//     {
//         $absolute_path = public_path() . '/' . "storage/upload/client" . '/' . $client_code . '/' . $qr_name;
//         $relative_path = asset('public/storage/upload/client') . '/' . $client_code . '/' . $qr_name;
//         $input = array("qr_id" => (int) $id, "client_code" => (string) $client_code, "client_id" => (int) $client_id);
//         $sensitive_value = implode(', ', array_map(
//             function ($v, $k) { return sprintf("%s='%s'", $k, $v); },
//             $input,
//             array_keys($input)
//         ));
//         // $merge_text_name = $this->make_img_of_text($id, $client_code);
//         // dd($sensitive_value);
//         QrCode::format('png')
//             // ->merge(asset('/public/storage/upload/client') . '/' . $merge_text_name . '.png', 0.3, true)
//             ->size(200)
//             // ->generate($client_code, $absolute_path);
//             ->generate($sensitive_value, $absolute_path);
//         // Storage::delete('public/upload/client'.'/'.$merge_text_name . '.png');
//         QRDetail::create([
//             'qr_id' => $id,
//             'client_id' => $client_id,
//             'client_code' => $client_code,
//             'qr_path' => $relative_path
//         ]);
//     }


// $qualification = Qualification::create([
//     'marshalId' => $userInstance->id,
//     'username' => $userInstance->username,
//     'resume' => $request->file('resume'),
//     'graduate' => $request->file('graduate'),
//     'postGraduate' => $request->file('postGraduate'),
//     'highSchool' => $request->file('highSchool'),
//     'intemediate' => $request->file('intemediate'),
//     'workExp' => $request->file('workExp'),
// ]);



// public function giveMapDetails(Request $request, $roleType=null, $search=null) {
//     if($request->ajax()){
//         $allRoles = Role::select('name')
//             ->where('name', '!=', 'admin')
//             ->get()
//             ->toArray();
//         $rolesWithInfo = [];
//         foreach (array_reverse($allRoles) as $value) {
//             $usersWithRoles = User::role($value['name'])
//                 ->where('users.name', 'LIKE', "%{$search}%")
//                 ->select('id', 'name', 'email', 'username', 'contactNumber', 'address')
//                 ->get();
//                 // ->paginate(4);
//             foreach($usersWithRoles as $user){
//                 // dd($user->id);
//                 if($value['name'] == 'client'){
//                     $contactPerson = Client::where('clientId', $user->id)->select('contactName')->first();
//                     $user->contactPerson = $contactPerson->contactName;
//                 }elseif($value['name'] == 'vendor'){
//                     $contactPerson = Vendor::where('vendorId', $user->id)->select('contactName')->first();
//                     $user->contactPerson = $contactPerson->contactName;
//                 }
//             }
//             array_push($rolesWithInfo, array($value['name'] => $usersWithRoles->toArray()));
//         }
//         return Response($this->render_map_html($rolesWithInfo));
//         // return view('Admin::mapFormTable', compact('rolesWithInfo'));
//     }else{
//         return view('Admin::map/create_map');
//     }
// }

// // Map Detail thorugh get() Method
    // protected function render_map_html($role_details)
    // {
    //     // dd($role_details);
    //     $roles = [];
    //     $client = $vendor = $marshal = $output = "";
    //     foreach($role_details as $role){
    //         // dd($role);
    //         foreach($role as $role_name => $role_detail){
    //             // dd($role_detail);
    //             if($role_name == "client")
    //             {
    //                 foreach ($role_detail as $key => $value) {
    //                     // dd($key, $value);
    //                     $label = "<label class='radio' onclick=" . '"' . "checkClients".
    //                     "({'id':".$value['id'].
    //                     ", 'name':". "'" .$value['name']. "'".
    //                     ", 'email':". "'" .$value['username']."'".
    //                     ", 'contactName':"."'".$value['contactPerson']."'".
    //                     ", 'contactNumber':"."'".$value['contactNumber']."'".
    //                     ", 'currentElement': this});" . '"' . "><input type='radio' name='clientValue' id='" . $value['username'] . "' value='" . $value['username'] . "' />" . "<span></span></label>";
    //                     // dd($label);
    //                     $client.='<tr>'.
    //                     '<td class="text-center">'.++$key.'</td>'.
    //                     '<td class="text-center">'.$value['name'].'</td>'.
    //                     '<td class="text-center">'.$value['username'].'</td>'.
    //                     '<td class="text-center">'.$value['contactPerson'].'</td>'.
    //                     '<td class="text-center">'.$value['contactNumber'].'</td>'.
    //                     '<td class="d-flex justify-content-center">'.$label.'</td>'.
    //                     '</tr>';
    //                 }
    //             }
    //             elseif($role_name == "vendor")
    //             {
    //                 foreach ($role_detail as $key => $value) {
    //                     // dd($key, $value);
    //                     $inp = "<input type='checkbox' class='inp-cbx position-fixed' id='".$value['username']."' value='".$value['username']."' name='vendorValue[".$value['id']."]' />";
    //                     $label = "<label class='cbx'". "for='". $value['username'] ."'"."onclick=" . '"' . "checkVendors".
    //                     "({'id':".$value['id'].
    //                     ", 'name':". "'" .$value['name']. "'".
    //                     ", 'email':". "'" .$value['username']."'".
    //                     ", 'contactName':"."'".$value['contactPerson']."'".
    //                     ", 'contactNumber':"."'".$value['contactNumber']."'".
    //                     ", 'currentElement': this});" . '"' . "><span><svg width='12px' height='11px' viewBox='0 0 12 11'><polyline points='1 6.29411765 4.5 10 11 1'></polyline></svg></span></label>";
    //                     // dd($label);
    //                     $vendor.='<tr>'.
    //                     '<td class="text-center">'.++$key.'</td>'.
    //                     '<td class="text-center">'.$value['name'].'</td>'.
    //                     '<td class="text-center">'.$value['username'].'</td>'.
    //                     '<td class="text-center">'.$value['contactPerson'].'</td>'.
    //                     '<td class="text-center">'.$value['contactNumber'].'</td>'.
    //                     '<td class="d-flex justify-content-center">'.$inp.$label.'</td>'.
    //                     '</tr>';
    //                 }
    //             }
    //             elseif($role_name == "sitemarshal")
    //             {
    //                 foreach ($role_detail as $key => $value) {
    //                     // dd($key, $value);
    //                     $inp = "<input type='checkbox' class='inp-cbx position-fixed' id='".$value['username']."' value='".$value['username']."' name='marshalValue[".$value['id']."]' />";
    //                     $label = '<label class="radio" onclick="checkClients({' . '"id":' . $value['id'] . ', "name":' . $value['name'] . ', "email":' . $value['username'] . ', "contactName":' . $value['name'] . ', "contactNumber":' . $value['contactNumber'] . ', "currentElement":this});"' . '<span><svg width="12px" height="11px" viewBox="0 0 12 11"><polyline points="1 6.29411765 4.5 10 11 1"></polyline></svg></span>';
    //                     $label = "<label class='cbx'". "for='". $value['username'] ."'"."onclick=" . '"' . "checkMarshals".
    //                     "({'id':".$value['id'].
    //                     ", 'name':". "'" .$value['name']. "'".
    //                     ", 'email':". "'" .$value['username']."'".
    //                     ", 'contactName':"."'".$value['name']."'".
    //                     ", 'contactNumber':"."'".$value['contactNumber']."'".
    //                     ", 'currentElement': this});" . '"' . "><span><svg width='12px' height='11px' viewBox='0 0 12 11'><polyline points='1 6.29411765 4.5 10 11 1'></polyline></svg></span></label>";
    //                     // dd($label);
    //                     $marshal.='<tr>'.
    //                     '<td class="text-center">'.++$key.'</td>'.
    //                     '<td class="text-center">'.$value['name'].'</td>'.
    //                     '<td class="text-center">'.$value['username'].'</td>'.
    //                     '<td class="text-center">'.$value['contactNumber'].'</td>'.
    //                     '<td class="d-flex justify-content-center">'.$inp.$label.'</td>'.
    //                     '</tr>';
    //                 }
    //             }
    //         }
    //         $roles['client'] = $client;
    //         $roles['vendor'] = $vendor;
    //         $roles['sitemarshal'] = $marshal;
    //     }
    //     return $roles;
    // }

