<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;
    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if($this->data['type'] == 'usercreate'){
            return $this->view('emails.rolesInvitation')
                ->with('data', $this->data)
                ->subject('Role Invitation!');
        }elseif($this->data['type'] == 'newConcern'){
            return $this->view('emails.concernedRaised')
                ->with('data', $this->data)
                ->subject($this->data['subject']);
        }elseif($this->data['type'] == 'newEvent'){
            return $this->view('emails.addedEvent')
                ->with('data', $this->data)
                ->subject('Raised Event!');
        }elseif($this->data['type'] == 'newMapping'){
            return $this->view('emails.relationMapped')
                ->with('data', $this->data)
                ->subject('Relational Mapping!');
        }elseif($this->data['type'] == 'expireClientDoc'){
            return $this->view('emails.expireClientDoc')
                ->with('data', $this->data)
                ->subject('Client Agreement Expiry Notification!');
        }elseif($this->data['type'] == 'expireVendorDoc'){
            return $this->view('emails.expireVendorDoc')
                ->with('data', $this->data)
                ->subject('Vendor Documents Expiry Notification!');
        }elseif($this->data['type']=='aiFeedsEmail'){
            return $this->view('emails.aiFeedsAlert')
                ->with('data', $this->data)
                ->subject('AI Feeds Alert Mail');
        }
    }
}
