<?php namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Models\Role;
use Illuminate\Http\Request;
use App\Mail\SendMail;
use DB;;
use File;
use DateTime;
use DatePeriod;
use DateInterval;

use App\ClientDocs;


class ClientAgreement extends Command {

    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'client:agreement';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle() {
//        \Log::info("client:agreement" . date("Y-m-d H:i:s"));
        $this->clientAgreementEndNotify();
    }
    

    //Client Agreement End Date Notification Cron Function
    public function dateDiffInDays($currentDate, $client_agreement_end_date) {
      // Calculating the difference in timestamps 
      $diff = strtotime($client_agreement_end_date) - strtotime($currentDate); 
      
      // 1 day = 24 hours 
      // 24 * 60 * 60 = 86400 seconds 
      return abs(round($diff / 86400)); 
    }
    
    //Send Email Process
    protected function sendExpiryNotificationMail($type, $fkAdminEmailID, $clintEmailID, $subject, $additional_data)
    {
      $existingData = array(
          'type' => $type,
          'subject' => $subject,
          'mailId' => $fkAdminEmailID,
          'ccmailId' => $clintEmailID,
          'note' => 'This is a Test Email only..',
      );
      $data = array_merge($existingData, $additional_data);
      $res = Mail::to($fkAdminEmailID)
              //->cc(['name1@domain.com','name2@domain.com'])
              ->cc($clintEmailID)
              ->send(new SendMail($data));
      //\Log::info("Send Client Agreement Expiry Mail");
    }
    
    public function clientAgreementEndNotify() {
      $clients = ClientDocs::distinct('clientId')
              ->select('clientId', 'client_agreement_end_date')
              ->get();
      foreach($clients as $client){
        $clientId = $client['clientId'];
        $client_agreement_end_date = $client['client_agreement_end_date'];
        if(isset($client_agreement_end_date) && !empty($client_agreement_end_date)){
          $currentDate = date('Y-m-d');
          if($currentDate > $client_agreement_end_date){
            echo "Already Expired!!";
          } else {
            $diffdays = $this->dateDiffInDays($currentDate, $client_agreement_end_date);
            if($diffdays<=15){
              
              //Fetch FoodsKraft Admin Email
              $fkAdminData = DB::table('model_has_roles')
                              ->join('users', 'model_has_roles.role_id', '=', 'users.id')
                              ->select('users.email')
                              ->first();
              $fkAdminEmailID = $fkAdminData->email;
              
              //Fetch Client Email 
              $clientData = DB::table('users')
                      ->join('clients', 'users.id', '=', 'clients.clientId')
                      ->select('users.name', 'users.username', 'users.contactNumber', 'users.email', 'clients.contactName', 'clients.headOffice')
                      ->where('users.id', '=', $clientId)
                      ->first();
              $clintEmailID = $clientData->email;
              
              $mail_info['client'] = [];
              array_push($mail_info['client'], $clientData);
              
              //Send Notification Email
              $this->sendExpiryNotificationMail('expireClientDoc', $fkAdminEmailID, $clintEmailID, 'Client Agreement Expiry Notification!', $mail_info);
              

            } else {
              echo "It is ok for now!!";
              echo "<br/>";
            }
          }         
        }
      }
              
    }

}