

<?php $__env->startSection('title', 'Generate Certificate'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <!-- Page Header -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h4>Generate Certificate</h4>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Generate Certificate</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-lg-12">
                    <div class="card p-4">

                        

                        <?php if($volunteer): ?>
                            <div class="certificate mx-auto" id="certificate">
                                <img src="<?php echo e(asset('logo-1726730459.webp')); ?>" alt="Logo" class="certificate-logo">
                                <div class="certificate-content">
                                    <h2>CERTIFICATE OF MEMBERSHIP</h2>
                                    <p class="subtitle">This is to certify that</p>
                                    <div class="name"><?php echo e($volunteer->name); ?></div>
                                    <div class="content">
                                        has been granted full membership in 
                                        <strong>GMM Educational Trust and Welfare Association</strong>.
                                    </div>
                                    <div class="footer">
                                        <div class="date">
                                            <div><?php echo e($volunteer->issue_date ?? ($volunteer->created_at ? $volunteer->created_at->format('d-m-Y') : now()->format('d-m-Y'))); ?></div>
                                            <div class="line"></div>
                                            <div>Date</div>
                                        </div>
                                        <div class="sign">
                                            <div>GMM</div>
                                            <div class="line"></div>
                                            <div>Authorized Signature</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="qr-block">
                                    <img crossOrigin="anonymous" src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?php echo e(url('certificate/verify?id='.$volunteer->id)); ?>" alt="QR Code">
                                    <div class="cert-id">GMM-<?php echo e($volunteer->id); ?></div>
                                </div>
                            </div>

                            <div class="text-center mt-4">
                                <button id="download-certificate-png" class="btn btn-success me-2">Download PNG</button>
                                <button id="print-certificate" class="btn btn-warning">Print Certificate</button>
                            </div>
                        <?php elseif(request('id')): ?>
                            <div class="alert alert-danger mt-4">Volunteer not found.</div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

        </div>
    </section>
</div>


<style>
    body {
      background-color: #f8f9fa;
      font-family: 'Georgia', serif; /* keep original */
    }
    .certificate {
      width: 100%;
      max-width: 900px;
      height: 650px;
      background: linear-gradient(to bottom right, #f0f4f8, #ffffff);
      border: 10px solid #1e3a8a;
      border-image: linear-gradient(to bottom right, #1e3a8a, #ffd700) 1;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
      position: relative;
      padding: 60px 80px;
      overflow: hidden;
    }
    .certificate::before {
      content: '';
      position: absolute; top: -5px; left: -5px; right: -5px; bottom: -5px;
      border: 2px dashed #ffd700; z-index: 1;
    }
    .certificate::after {
      content: '';
      background: url('<?php echo e(asset('logo-1726730459.webp')); ?>') center center no-repeat;
      background-size: 300px;
      opacity: 0.05;
      position: absolute; inset: 0;
      z-index: 0;
    }
    .certificate-logo {
      position: absolute; top: 25px; left: 50%; transform: translateX(-50%);
      height: 80px; z-index: 3; background: #000; border-radius: 50%; padding: 5px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    .certificate-content { position: relative; z-index: 2; text-align: center; color: #1e3a8a; padding-top: 80px; }
    .certificate h2 { font-size: 48px; font-weight: 700; text-transform: uppercase; margin-bottom: 10px; letter-spacing: 2px; color: #1e3a8a; }
    .certificate .subtitle { font-size: 20px; font-style: italic; margin-bottom: 30px; color: #2d5b9c; }
    .certificate .name { font-size: 36px; font-weight: 700; margin: 30px 0 20px; color: #0d2f6b; text-transform: uppercase; letter-spacing: 1px; text-shadow: 1px 1px 3px rgba(255, 215, 0, 0.3);}
    .certificate .content { font-size: 18px; line-height: 1.6; margin-bottom: 40px; color: #333; }
    .certificate .footer { display: flex; justify-content: space-between; margin-top: 50px; font-size: 16px; color: #1e3a8a; }
    .certificate .footer div { text-align: center; flex: 1; }
    .certificate .footer .line { width: 140px; height: 1px; background-color: #1e3a8a; margin: 8px auto 6px; }
    .qr-block { position: absolute; top: 30px; right: 30px; text-align: center; z-index: 3; }
    .qr-block img { width: 80px; height: 80px; background: #fff; padding: 5px; border: 1px solid #ccc; }
    .qr-block .cert-id { margin-top: 8px; font-size: 13px; font-weight: bold; color: #333; }
</style>


<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
<script>
    document.getElementById('download-certificate-png')?.addEventListener('click', function() {
        var cert = document.getElementById('certificate');
        html2canvas(cert, { scale: 2, useCORS: true, backgroundColor: null }).then(function(canvas) {
            var link = document.createElement('a');
            link.download = 'certificate.png';
            link.href = canvas.toDataURL();
            link.click();
        });
    });
    document.getElementById('print-certificate')?.addEventListener('click', function() {
        var cert = document.getElementById('certificate');
        html2canvas(cert, { scale: 2, useCORS: true, backgroundColor: null }).then(function(canvas) {
            const imgData = canvas.toDataURL('image/png');
            const win = window.open('');
            win.document.write('<html><head><title>Print Certificate</title></head><body style="margin:0;">');
            win.document.write('<img src="' + imgData + '" onload="setTimeout(() => window.print(), 100)" style="width:100%;">');
            win.document.write('</body></html>');
            win.document.close();
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\gmm\resources\views/certificate.blade.php ENDPATH**/ ?>