

<?php $__env->startSection('title'); ?>
    Donate List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Donate List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Donate List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Donate List</h2>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            
                                            <th>Email</th>
                                            <th>Mobile Number</th>
                                            <th>Payment Type</th>
                                            <th>Amount</th>
                                            <th>UTR Number</th>
                                            <th>Screenshot</th> <!-- New column -->
                                            <th>Payment Status</th>
                                            <th>Addon</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?>.</td>
                                                <td><?php echo e($donation['name']); ?></td>
                                                
                                                <td><?php echo e($donation['email']); ?></td>
                                                <td><?php echo e($donation['phone']); ?></td>
                                                <td><?php echo e($donation['payment_type']); ?></td>
                                                <td><?php echo e($donation['amount']); ?></td>
                                                <td><?php echo e($donation['utr_number']); ?></td>

                                                <!-- Screenshot column -->
                                                <td>
                                                    <?php if($donation->screenshot): ?>
                                                        <a href="<?php echo e(asset($donation->screenshot)); ?>" target="_blank">
                                                            <img src="<?php echo e(asset($donation->screenshot)); ?>" alt="Screenshot"
                                                                style="width:50px; height:auto; border-radius:5px;">
                                                        </a>
                                                    <?php else: ?>
                                                        N/A
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <select
                                                        class="form-control donation-status
                                                        <?php echo e($donation->status == 'confirmed' ? 'bg-success text-white' : ($donation->status == 'rejected' ? 'bg-danger text-white' : 'bg-warning text-dark')); ?>"
                                                        onchange="updateStatus(this)" data-id="<?php echo e($donation->id); ?>">

                                                        <option value="confirmed"
                                                            <?php echo e($donation->status == 'confirmed' ? 'selected' : ''); ?>>
                                                            Confirmed</option>
                                                        <option value="pending"
                                                            <?php echo e($donation->status == 'pending' ? 'selected' : ''); ?>>Pending
                                                        </option>
                                                        <option value="rejected"
                                                            <?php echo e($donation->status == 'rejected' ? 'selected' : ''); ?>>
                                                            Rejected</option>
                                                    </select>
                                                </td>

                                                <td><?php echo e($donation['created_at']->format('d/m/Y')); ?></td>
                                                
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<script>
    function updateStatus(selectElement) {
        let id = selectElement.getAttribute('data-id');
        let status = selectElement.value;
        let formData = new FormData();
        formData.append('id', id);
        formData.append('status', status);
        fetch("<?php echo e(route('donation.updateStatus')); ?>", {
                method: "POST",
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    alert("Status updated successfully!");
                } else {
                    alert("Failed to update status!");
                }
            })
            .catch(err => console.error(err));
    }
</script>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enexademo/public_html/gmmedu/resources/views/admin/reports/donation.blade.php ENDPATH**/ ?>