<!DOCTYPE html>
<html lang="en">
<head>
        <meta charset="utf-8" />
        <title>Login - ADMIN</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="Admin Dashboard" name="description" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
       <link rel="shortcut icon" href="<?php echo e(url('favicon.ico')); ?>">

        <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/fontawesome-free/css/all.min.css')); ?>">
        <!-- icheck bootstrap -->
        <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
        <!-- Theme style -->
        <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'dist/css/adminlte.min.css')); ?>">
        <style>
            .bg-gradient{
                background: url( <?php echo e((config('app.admin.asset').'dist/img/login-bg.webp')); ?> );
            }
        </style>
    </head>

    <body class="authentication-bg bg-gradient">

        <div class="account-pages pt-5 my-5">
            <div class="container mt-5">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-5">
                        <div class="account-card-box">
                              <div class="card card-outline card-primary">
                                <div class="card-header text-center">
                                  <a href="#" class="h2"><b>Login</b></a>
                                </div>
                                <div class="card-body">
                                  <p class="login-box-msg">Sign in to start your session</p>

                                <form action="<?php echo e(url('authenticate')); ?>" name="loginForm" id="loginForm" method="post">
                                  <?php echo e(csrf_field()); ?>

                                    <div class="input-group mb-3">
                                      <input type="text" class="form-control" required name="email" id="username" placeholder="Username">
                                      <div class="input-group-append">
                                        <div class="input-group-text">
                                          <span class="fas fa-envelope"></span>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="input-group mb-3">
                                      <input type="password" class="form-control" required name="password" id="password" placeholder="Password">
                                      <div class="input-group-append">
                                        <div class="input-group-text">
                                          <span class="fas fa-lock"></span>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="row">
                                      <!-- /.col -->
                                      <div class="col-12">
                                        <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                                      </div>
                                      <!-- /.col -->
                                    </div>
                                  </form>
                                  
                                </div> <!-- end card-body -->
                                <div class="px-3 py-0 my-0">
                                    <?php if(Session::has('flash')): ?>
                                    <?php $flash =  Session::get('flash'); Session::forget('flash');?>
                                        <div class="alert alert-<?php echo e($flash['error_type']); ?>"><?php echo e($flash['message']); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>

                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end page -->
        
        <script src="<?php echo e((config('app.admin.asset').'plugins/jquery/jquery.min.js')); ?>"></script>
        <!-- Bootstrap 4 -->
        <script src="<?php echo e((config('app.admin.asset').'plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
        <!-- AdminLTE App -->
        <script src="<?php echo e((config('app.admin.asset').'dist/js/adminlte.min.js')); ?>"></script>
        
        <script>
            setTimeout(function(){ $(".alert").hide(); }, 5000);
        </script>
        
    </body>
</html><?php /**PATH D:\xampp\htdocs\gmm\resources\views/admin/login.blade.php ENDPATH**/ ?>