

<?php $__env->startSection('title'); ?>
    Dashboard
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">

        <!-- Content Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Dashboard</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Panel</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main content -->
        <style>
            .section-title {
                background: linear-gradient(90deg, #0a00a3, #d11fa6);
                color: white;
                padding: 10px 25px;
                border-radius: 10px;
                display: inline-block;
                margin-bottom: 30px;
                font-weight: 600;
                box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            }

            .business-box-container {
                background: linear-gradient(to right bottom, #c1e4f8, #acd2f1);
                border-radius: 20px;
                box-shadow: inset 0 0 8px rgba(255,255,255,0.3);
                width: 100%;
            }

            .business-box {
                background: linear-gradient(135deg, #c2f0f7, #63a4ff);
                border-radius: 20px;
                padding: 20px;
                box-shadow: 6px 6px 10px rgba(0,0,0,0.3);
                transition: transform 0.3s ease;
                height: 100%;
            }

            .business-box:hover {
                transform: translateY(-5px);
            }

            .business-icon {
                font-size: 24px;
                color: #0a00a3;
                margin-right: 10px;
            }

            .business-count {
                font-size: 28px;
                font-weight: bold;
                color: #000;
                margin-bottom: 10px;
            }

            .report-btn {
                display: inline-block;
                background-color: #0000ff;
                color: #fff;
                padding: 5px 15px;
                border-radius: 8px;
                font-size: 14px;
                text-decoration: none;
                transition: 0.2s;
            }

            .report-btn:hover {
                background-color: #fff;
                color: #0000ff;
                border: 1px solid #0000ff;
            }

            @media (max-width: 768px) {
                .section-title {
                    font-size: 18px;
                    padding: 8px 18px;
                }

                .business-count {
                    font-size: 22px;
                }

                .report-btn {
                    padding: 4px 12px;
                    font-size: 13px;
                }
            }
        </style>

        <section class="content">
            <div class="container-fluid">
                <!-- Welcome Message -->
                <div class="row">
                    <div class="col-lg-12 mb-4 text-center">
                        <h1>Welcome to <strong><?php echo e(config('app.name')); ?></strong> Panel</h1>
                    </div>
                </div>

                <!-- Today Business Summary Section -->
                <div class="row mb-2">
                    <div class="col-12">
                        <div class="business-box-container p-4">
                            <h3 class="text-center section-title">Today Business Summary</h3>
                            <div class="row justify-content-center">
                                <div class="col-lg-6">
                                    <div class="business-box">
                                        <div class="d-flex align-items-center justify-content-between mb-3 border-bottom pb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-user business-icon"></i>
                                                <strong>Volunteer Registered</strong>
                                            </div>
                                            <span class="text-success fw-bold">0</span>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-between mb-3 border-bottom pb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-donate business-icon"></i>
                                                <strong>Donation Received</strong>
                                            </div>
                                            <span class="text-success fw-bold">0</span>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-calendar-alt business-icon"></i>
                                                <strong>Up-Coming Activities</strong>
                                            </div>
                                            <span class="text-success fw-bold">0</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Total Business Count Section -->
                <div class="row">
                    <div class="col-12">
                        <div class="business-box-container p-4">
                            <h3 class="text-center section-title">Total Business Count</h3>
                            <div class="row justify-content-center">
                                <?php
                                    $data = [
                                        ['label' => 'Branch', 'count' => 1],
                                        ['label' => 'Volunteer', 'count' => 0],
                                        ['label' => 'Total Donation', 'count' => 0],
                                    ];
                                ?>

                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 mb-5 px-3">
                                        <div class="business-box text-center">
                                            <div class="business-icon"><i class="fas fa-user"></i></div>
                                            <h5 class="mb-2"><?php echo e($item['label']); ?></h5>
                                            <h3 class="business-count"><?php echo e($item['count']); ?></h3>
                                            <a href="#" class="report-btn">Report</a>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\gmm\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>