<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>

    </ul>
    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
        <!-- Notifications Dropdown Menu -->


        <li class="nav-item dropdown">

            <a class="nav-link" data-toggle="dropdown" href="#">

                <?php if($user): ?>
                    <img src="<?php echo e($user->photo); ?>" alt="User Image" class="user-img img-circle elevation-2">
                <?php else: ?>
                    <img src="<?php echo e(asset('/Panel/images/user.png')); ?>" alt="User Image"
                        class="user-img img-circle elevation-2">
                <?php endif; ?>
                <b class="none">Welcome <?php echo e($user->name); ?></b>
                <i class="fas fa-chevron-down ml-1"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <span class="dropdown-item dropdown-header"><b>Welcome <?php echo e($user->name); ?>!</b></span>
                <div class="dropdown-divider"></div>
                <a href="<?php echo e(config('app.admin.url') . 'profile'); ?>" class="dropdown-item">
                    <i class="fas fa-user mr-2"></i> Profile
                </a>
                <div class="dropdown-divider"></div>
                <a href="<?php echo e(config('app.admin.url') . 'logout'); ?>" class="dropdown-item">
                    <i class="fas fa-arrow-circle-left mr-2 text-danger"></i>Logout
                </a>
            </div>
        </li>
    </ul>
</nav>
<!-- /.navbar -->

<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-warning elevation-4">
    <!-- Brand Logo -->
    <a href="" class="brand-link text-center">
        <span class="brand-text font-weight-thin text-uppercase"><span><b
                    style="font-weight:bold;"><?php echo e(config('app.name')); ?> PANEL</b></span>
    </a>
    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">

                <!-- ************************************ Start Menu ******************************************** -->




                <?php if($user->role=='developer'){ ?>
                
                <?php if($user->role == 'developer'): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(config('app.admin.url') . 'dashboard'); ?>" class="nav-link">
                            <i class="nav-icon fas fa-tachometer-alt"></i>
                            <p> Dashboard </p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="<?php echo e(config('app.admin.url') . 'settings'); ?>" class="nav-link">
                            <i class="nav-icon fas fa-cog"></i>
                            <p> Settings </p>
                        </a>
                    </li>
                <?php endif; ?>


                
                <?php if($user->role == 'developer'): ?>
                    
                <?php endif; ?>





                

                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-list"></i>
                        <p>
                            Project
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'project/create'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>New Project</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'project'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>All Project</p>
                            </a>
                        </li>
                    </ul>
                </li>


                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-newspaper"></i>
                        <p>
                            Announcement
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'news/create'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>New Announcement</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'news'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>All Announcement</p>
                            </a>
                        </li>
                    </ul>
                </li>

                

                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-image"></i>
                        <p>
                            Banner
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'banner/create'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>New Banner</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'banner'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>All Banner</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-images"></i>
                        <p>
                            Gallery
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'gallery/create'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>New Gallery</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'gallery'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>All Gallery</p>
                            </a>
                        </li>
                    </ul>
                </li>

                

                


                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-file-code"></i>
                        <p>
                            Dynamic Page
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'dynamic/create'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>New Dynamic Page</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'dynamic'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>All Dynamic Page</p>
                            </a>
                        </li>
                    </ul>
                </li>


                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'volunteer'); ?>" class="nav-link">
                        
                        <i class="nav-icon fas fa-handshake"></i>
                        <p> Volunteers </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'membership-list'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-users"></i>
                        <p> Membership </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'donation-list'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-donate"></i>
                        <p> Participant's Donation </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'donate'); ?>" class="nav-link">
                        
                        <i class="nav-icon fas fa-hand-holding-usd"></i>
                        <p> Guest's Donation </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'sports'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-award"></i>
                        <p> Sports </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'agriculture'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-award"></i>
                        <p> Agriculture </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'scholarship'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-award"></i>
                        <p> Scholarship </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'contact'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-envelope-open-text"></i>
                        <p> Contact Inquiry </p>
                    </a>
                </li>
                <?php } ?>

                
                <?php if($user->role=='volunteer'){ ?>
                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'dashboard'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-home"></i>
                        <p> Home </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'generate-idcard'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-id-card"></i>
                        <p> Id Card </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'generate-certificate'); ?>" class="nav-link">
                        
                        <i class="nav-icon fas fa-certificate"></i>
                        <p> Certificate </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'appointment-letter'); ?>" class="nav-link">
                        
                        <i class="nav-icon fas fa-file"></i>
                        <p> Appointment Letter </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'membership'); ?>" class="nav-link">
                        <i class="nav-icon  fas fa-users"></i>
                        <p> Apply For Menbership </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'donation'); ?>" class="nav-link ">
                        <i class="nav-icon fas fa-hand-holding-usd"></i>
                        <p> Donate Now </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-receipt"></i>
                        <p>
                            Reciept
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'donation/membership-receipt'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Membership Reciept</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(config('app.admin.url') . 'donation/donation-receipt'); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Donation Reciept</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(config('app.admin.url') . 'donation/payment-history'); ?>" class="nav-link">
                        <i class="nav-icon fas fa-clock"></i>
                        <p> Payment History </p>
                    </a>
                </li>

                <?php } ?>
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH /home/enexademo/public_html/gmmedu/resources/views/admin/includes/header.blade.php ENDPATH**/ ?>