

<?php $__env->startSection('title'); ?>
    Donation History
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">

        <!-- Content Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Donation History</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Donation History </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Donation History</h2>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            
                                            <th>Donor Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Amount</th>
                                            <th>Payment Type</th>
                                            <th>UTR Number</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Receipt</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $donations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $donation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?>.</td>
                                                
                                                <td><?php echo e($donation->name); ?></td>
                                                <td><?php echo e($donation->email); ?></td>
                                                <td><?php echo e($donation->phone); ?></td>
                                                <td>₹<?php echo e(number_format($donation->amount, 2)); ?></td>
                                                <td><?php echo e(ucfirst($donation->payment_type)); ?></td>
                                                <td><?php echo e($donation->utr_number ?? '-'); ?></td>
                                                <td>
                                                    <span
                                                        class="badge 
                                                    <?php echo e($donation->status == 'confirmed' ? 'badge-success' : ($donation->status == 'rejected' ? 'badge-danger' : 'badge-warning')); ?>">
                                                        <?php echo e(ucfirst($donation->status)); ?>

                                                    </span>
                                                </td>
                                                <td><?php echo e($donation->created_at->format('d/m/Y h:i A')); ?></td>
                                                <td>
                                                    <?php if($donation->payment_type == 'membership'): ?>
                                                        <a href="<?php echo e(url('master/donation/membership-receipt')); ?>"
                                                            class="btn btn-sm btn-warning">
                                                            <i class="fa fa-receipt"></i> Receipt
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="<?php echo e(url('master/donation/donation-receipt?id=' . $donation->id)); ?>"
                                                            class="btn btn-sm btn-warning">
                                                            <i class="fa fa-receipt"></i> Receipt
                                                        </a>
                                                    <?php endif; ?>
                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/enexademo/public_html/gmmedu/resources/views/admin/payment_history.blade.php ENDPATH**/ ?>