

<?php $__env->startSection('title'); ?>
    Project View
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Project View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Project View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Project View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="<?php echo e(config('app.admin.url') . 'project'); ?>">
                                    <i class="fa fa-list"></i> Project List</a>
                            </div>


                            <div class="row">
                                
                                <?php if(!empty($project->banner) || !empty($project->image)): ?>
                                <div class="col-md-6">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="banner">Banner Image</label>
                                            <?php if(isset($project->banner)): ?>
                                                 <img src="<?php echo e(asset('assets/project/banner/' . $project->banner)); ?>"
                                                class="img-fluid img-thumbnail" alt="<?php echo e($project->title); ?>" />
                                                <a href="<?php echo e(asset('assets/project/banner/' . $project->banner)); ?>"
                                                    target="new" class="btn btn-default form-control">Go to File</a>
                                            <?php endif; ?>
                                           
                                        </div>

                                        <div class="form-group">
                                            <label for="image">Image</label>
                                            <?php if(isset($project->image)): ?>
                                            <img src="<?php echo e(asset('assets/project/meta/' . $project->image)); ?>"
                                                class="img-fluid img-thumbnail" alt="<?php echo e($project->title); ?>" />
                                            <a href="<?php echo e(asset('assets/project/meta/' . $project->image)); ?>"
                                                target="new" class="btn btn-default form-control">Go to File</a>
                                                <?php endif; ?>
                                        </div>

                                        
                                    </div>
                                </div>
                                

                                <div class="col-md-6">
                                    <?php else: ?>
                                    <div class="col-md-12">
                                    <?php endif; ?>
                                <div class="card-body">

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Home</label>
                                            <select name="home" class="form-control" disabled>
                                                <option value="1" <?php if($project->home == 1): ?> selected <?php endif; ?>>
                                                    Active</option>
                                                <option value="0" <?php if($project->home == 0): ?> selected <?php endif; ?>>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                      

                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control" disabled>
                                                <option value="1" <?php if($project->status == 1): ?> selected <?php endif; ?>>
                                                    Active</option>
                                                <option value="0" <?php if($project->status == 0): ?> selected <?php endif; ?>>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="title">Project Name</label>
                                            <input type="text" class="form-control" id="name" name="name"
                                                disabled value="<?php echo e($project->name); ?>">
                                        </div>
                                        
                                        
                                        <div class="form-group">
                                            <label for="title">Title</label>
                                            <input type="text" class="form-control" id="title" name="title"
                                                disabled value="<?php echo e($project->title); ?>">
                                        </div>                                
                                    
                                        <div class="form-group">
                                            <label for="title">Keywords</label>
                                            <input type="text" class="form-control" id="meta_keywords"
                                                name="meta_keywords" value="<?php echo e($project->meta_keywords); ?>" disabled>
                                        </div>

                                        <div class="form-group">
                                            <label for="title">Description</label>
                                            <textarea class="form-control" rows="5" id="meta_description" disabled name="meta_description"><?php echo e($project->meta_description); ?></textarea>
                                        </div>
                                        

                                        <div class="form-group">
                                            <label for="title">Additional </label>
                                            <textarea class="form-control" rows="5" id="additional" disabled name="additional"><?php echo e($project->additional); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <?php if($project->page=="custom"): ?>
                                <div class="col-md-12">
                                    <div class="card-body">
                                        
                                        <div class="form-group">
                                            <label for="title">Page Details</label>
                                            <div class="p-2 border"><?php echo $project->details; ?></div>
                                        </div>
                                    </div>
                                    </div>
                              <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view') . '.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gmmedutrust/public_html/resources/views/admin/project/show.blade.php ENDPATH**/ ?>