<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
 <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta content="<?php echo $__env->yieldContent('site_name', $settings->site_name); ?>" name="author" />
  <meta name="theme-color" content="<?php echo $__env->yieldContent('theme_color', $settings->theme_color); ?>" />
  <link rel="shortcut icon" href="<?php echo e(asset('')); ?><?php echo $__env->yieldContent('favicon', $settings->favicon); ?>">
  <link rel="apple-touch-icon" href="<?php echo e(asset('')); ?><?php echo $__env->yieldContent('favicon', $settings->favicon); ?>" />
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', $settings->title); ?> || Admin Panel</title>
    <meta content="<?php echo $__env->yieldContent('title', $settings->title); ?>" name="title" />
    <meta content="<?php echo $__env->yieldContent('meta_keywords', $settings->meta_keywords); ?>" name="keyword" />
    <meta content="<?php echo $__env->yieldContent('meta_description', $settings->meta_description); ?>" name="description" />

  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css')); ?>">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/select2/css/select2.min.css')); ?>">
  <!-- Tempusdominus Bbootstrap 4 -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>">
  <!-- iCheck -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <!-- JQVMap -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/jqvmap/jqvmap.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'dist/css/adminlte.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'dist/css/main.css')); ?>">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/daterangepicker/daterangepicker.css')); ?>">
  
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/bootstrap/bootstrap-tagsinput.css')); ?>">
  <!-- summernote -->
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'plugins/summernote/summernote-bs4.css')); ?>">
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'dropify/dropify.min.css')); ?>" />
  <link rel="stylesheet" href="<?php echo e((config('app.admin.asset').'sweetalert/sweetalert.min.css')); ?>" />
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    [class*=sidebar-dark-] {
    background-color: #000000;
}
.card-primary:not(.card-outline)>.card-header {
    background-color: #ffc107;
}
.card-primary:not(.card-outline)>.card-header, .card-primary:not(.card-outline)>.card-header a {
    color: #000;
}
.btn-dark {
    background-color: #000000;
    border-color: #000000;
}
.nav-pills .nav-link.active, .nav-pills .show>.nav-link {
    color: #000000;
    background-color: #ffc107;
}
.card-primary.card-outline {
    border-top: 3px solid #ffc107;
}
  </style>

  <!-- jQuery -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/jquery/jquery.min.js')); ?>"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <?php echo $__env->make(config('app.admin.view').".includes.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php echo $__env->yieldContent("content"); ?>

  <?php echo $__env->make(config('app.admin.view').".includes.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
    <!-- ./wrapper -->

  <script>
    $.widget.bridge('uibutton', $.ui.button)
  </script>
  <!-- Bootstrap 4 -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/bootstrap/bootstrap-tagsinput.min.js')); ?>"></script>
  <!-- DataTables -->
  <script src="<?php echo e((config('app.admin.asset').'dropify/dropify.min.js')); ?>"></script>

  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/jszip/jszip.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/pdfmake/pdfmake.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/pdfmake/vfs_fonts.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>


  <!-- bootstrap color picker -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')); ?>"></script>
  <!-- Sparkline -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/sparklines/sparkline.js')); ?>"></script>
  <!-- JQVMap -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/jqvmap/jquery.vmap.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/jqvmap/maps/jquery.vmap.usa.js')); ?>"></script>
  <!-- jQuery Knob Chart -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/jquery-knob/jquery.knob.min.js')); ?>"></script>
  <!-- daterangepicker -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/moment/moment.min.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'plugins/daterangepicker/daterangepicker.js')); ?>"></script>
  <!-- Select2 -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/select2/js/select2.full.min.js')); ?>"></script>
  <!-- Tempusdominus Bootstrap 4 -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>
  <!-- Summernote -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/summernote/summernote-bs4.min.js')); ?>"></script>
  <!-- overlayScrollbars -->
  <script src="<?php echo e((config('app.admin.asset').'plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>"></script>
  <!-- AdminLTE App -->
  <script src="<?php echo e((config('app.admin.asset').'dist/js/adminlte.js')); ?>"></script>
  <script src="<?php echo e((config('app.admin.asset').'dist/js/main.js')); ?>"></script>
<script>
  $(document).ready(function() { 
            $('table.display').DataTable(); 
            });
</script>
  <!-- Sweet Alert -->
  <script src="<?php echo e((config('app.admin.asset').'sweetalert/sweetalert.min.js')); ?>"></script>


  <?php if(session()->has('success')): ?>
    <script>
      Swal.fire({
        title: "Success!",
        html: "<?php echo e(session()->get('success')); ?>",
        type: "success",
        showConfirmButton: true,
        timer: 5000
      });
    </script>
  <?php endif; ?>
  

  <?php if(session()->has('error')): ?>
    <script>
      Swal.fire({
        title: "Error!",
        html: "<?php echo e(session()->get('error')); ?>",
        type: "error",
        showConfirmButton: true,
        timer: 5000
      });
    </script>
  <?php endif; ?>
  
  <?php if($errors->any()): ?>
    <script>
      Swal.fire({
        title: "Error!",
        html: "<ul class='text-left m-auto d-block'> <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li><?php echo e($error); ?></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </ul>",
        type: "error",
        showConfirmButton: true,
      });
    </script>
  <?php endif; ?>


  <script>
    /** add active class and stay opened when selected */
    var url = window.location;

    // for sidebar menu entirely but not cover treeview
    $('ul.nav-sidebar a').filter(function() {
        return this.href == url;
    }).addClass('active');

    // for treeview
    $('ul.nav-treeview a').filter(function() {
        return this.href == url;
    }).parentsUntil(".nav-sidebar > .nav-treeview").addClass('menu-open').prev('a').addClass('active');

    // for treeview //
    $('ul.nav-treeview a').filter(function() {
        return url.href.includes(this.href);
    }).parentsUntil(".nav-sidebar > .nav-treeview").addClass('menu-open').prev('a').addClass('active');
  </script>

</body>

</html><?php /**PATH /home/enexademo/public_html/gmmedu/resources/views/admin/layouts/master.blade.php ENDPATH**/ ?>