

<?php $__env->startSection('title'); ?>
    Gallery List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Gallery List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Gallery List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Gallery List</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="<?php echo e(config('app.admin.url') . 'gallery/create'); ?>">
                                    <i class="fa fa-plus"></i> Add Gallery</a>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Title</th>
                                            
                                            
                                            <th>Status</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      <?php $__currentLoopData = $gallerys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr>
                                            <td><?php echo e($key+1); ?>.</td>
                                            <td><?php echo e($gallery['title']); ?></td>
                                            
                                            
                                            <td>
                                                <?php if($gallery['status'] == 1): ?>
                                                    Active
                                                <?php else: ?>
                                                    Not Active
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($gallery['created_at']->format('d/m/Y')); ?></td>
                                            <td>
                                                <a class="btn btn-info btn-sm my-1"
                                                    href="<?php echo e((config('app.admin.url').'gallery/show/'.encrypt($gallery->id))); ?>"
                                                    title="Show"><i class="fa fa-eye"></i></a>
                                                <a class="btn btn-primary btn-sm my-1"
                                                    href="<?php echo e((config('app.admin.url').'gallery/edit/'.encrypt($gallery->id))); ?>"
                                                    title="Edit"><i class="fa fa-edit"></i></a>
                                                <a class="btn btn-danger btn-sm my-1"
                                                    href="<?php echo e((config('app.admin.url').'gallery/destroy/'.encrypt($gallery->id))); ?>"
                                                    title="Delete"><i class="fa fa-trash"></i></a>
                                            </td>
                                        </tr>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(config('app.admin.view').".layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gmmedutrust/public_html/resources/views/admin/gallery/index.blade.php ENDPATH**/ ?>