<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\DynamicController;
use App\Http\Controllers\Admin\GalleryController;
use App\Http\Controllers\Admin\PartnerController;
use App\Http\Controllers\Admin\ReviewController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\CareerController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\NewsController;
use App\Http\Controllers\Admin\EventsController;
use App\Http\Controllers\Admin\IndustryController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// admin routes

Route::get(config('app.admin.route'), [LoginController::class, 'index']);
Route::post('authenticate', [LoginController::class, 'authenticate']);

Route::get('/', [HomeController::class, 'index']);
Route::get('/about-us', [HomeController::class, 'about']);
Route::get('/blog', [HomeController::class, 'blog']);
Route::get('/blog/{slug}', [HomeController::class, 'blogDetails']);
Route::get('/gallery', [HomeController::class, 'gallery']);
Route::get('/testimonials', [HomeController::class, 'testimonials']);
Route::get('/contact', [HomeController::class, 'contact']);
Route::get('/scholarship', [HomeController::class, 'scholarship']);
Route::post('/scholarship', [HomeController::class, 'submitscholarship']);
Route::get('/donate-now', [HomeController::class, 'donate']);
Route::get('/volunteer', [HomeController::class, 'volunteer']);
Route::post('/donate', [HomeController::class, 'submitdonate']);
Route::post('/volunteer', [HomeController::class, 'submitvolunteer']);
Route::get('/index.html', [HomeController::class, 'index']);
Route::get('/projects', [HomeController::class, 'project']);
Route::get('/district', [HomeController::class, 'district']);
Route::get('/project/{id}', [HomeController::class, 'projectDetails']);
Route::post('/sports-form', [HomeController::class, 'submitsports']);
Route::post('/agriculture-form', [HomeController::class, 'submitagriculture']);
Route::get('/announcements', [HomeController::class, 'news']);
Route::get('/announcements/{id}', [HomeController::class, 'newsDetails']);
Route::get('/events', [HomeController::class, 'events']);
Route::get('/events/{id}', [HomeController::class, 'eventsDetails']);


Route::get('/industry', [HomeController::class, 'industry']);
Route::get('/industry/{id}', [HomeController::class, 'industryDetails']);
Route::post('/contact-send', [HomeController::class, 'sendContactForm']);
Route::get('{page}', [HomeController::class, 'dynamicPage']);


Route::group(['prefix' => '/' . config('app.admin.route'), 'middleware' => 'adminauth'], function () {
    // admin initial
    Route::get('dashboard', [AdminController::class, 'index']);
    Route::get('profile', [AdminController::class, 'profile']);
    Route::post('profile_update', [AdminController::class, 'profile_update']);
    Route::get('settings', [AdminController::class, 'settings']);
    Route::post('settings/update/{file}', [AdminController::class, 'update']);
    Route::post('settings/updatecat/{file}', [AdminController::class, 'updatecat']);
    Route::post('settings/update', [AdminController::class, 'update']);
    Route::get('/logout', [LoginController::class, 'logout']);

    Route::get('/generate-idcard', [HomeController::class, 'idCard']);
    Route::get('/generate-certificate', [HomeController::class, 'certificate']);
    Route::get('certificate/verify', [HomeController::class, 'verify']);
    Route::get('/membership', [HomeController::class, 'membershipForm']);
    Route::post('/membership', [HomeController::class, 'submitMembership']);
    Route::get('/donation', [HomeController::class, 'donation'])->name('donation.page');
    Route::post('/donation', [HomeController::class, 'submitDonation'])->name('donation.submit');
    Route::post('/donation/update-status', [HomeController::class, 'updateStatus'])->name('donation.updateStatus');
    Route::get('/donation/donation-receipt', [HomeController::class, 'showDonationReceipt'])->name('donation.receipt');
    Route::get('/donation/membership-receipt', [HomeController::class, 'showMembershipReceipt'])->name('membership.receipt');
    Route::get('/donation/payment-history', [HomeController::class, 'paymentHistory'])->name('donation.payment.history');
    Route::get('/appointment-letter', [HomeController::class, 'appointmentLetter']);





    // users route
    Route::get('/user/create', [UserController::class, 'create']);
    Route::post('/user/store', [UserController::class, 'store']);
    Route::get('/user/show/{id}', [UserController::class, 'show']);
    Route::get('/user/edit/{id}', [UserController::class, 'edit']);
    Route::patch('/user/update/{id}', [UserController::class, 'update']);
    Route::get('/user/destroy/{id}', [UserController::class, 'destroy']);
    Route::get('/user', [UserController::class, 'index']);


    // project route
    Route::get('/project/create', [ProductController::class, 'create']);
    Route::post('/project/store', [ProductController::class, 'store']);
    Route::get('/project/show/{id}', [ProductController::class, 'show']);
    Route::get('/project/edit/{id}', [ProductController::class, 'edit']);
    Route::patch('/project/update/{id}', [ProductController::class, 'update']);
    Route::get('/project/destroy/{id}', [ProductController::class, 'destroy']);
    Route::get('/project', [ProductController::class, 'index']);

    // industry route
    Route::get('/industry/create', [IndustryController::class, 'create']);
    Route::post('/industry/store', [IndustryController::class, 'store']);
    Route::get('/industry/show/{id}', [IndustryController::class, 'show']);
    Route::get('/industry/edit/{id}', [IndustryController::class, 'edit']);
    Route::patch('/industry/update/{id}', [IndustryController::class, 'update']);
    Route::get('/industry/destroy/{id}', [IndustryController::class, 'destroy']);
    Route::get('/industry', [IndustryController::class, 'index']);


    // dynamic route
    Route::get('/dynamic/create', [DynamicController::class, 'create']);
    Route::post('/dynamic/store', [DynamicController::class, 'store']);
    Route::get('/dynamic/show/{id}', [DynamicController::class, 'show']);
    Route::get('/dynamic/edit/{id}', [DynamicController::class, 'edit']);
    Route::patch('/dynamic/update/{id}', [DynamicController::class, 'update']);
    Route::get('/dynamic/destroy/{id}', [DynamicController::class, 'destroy']);
    Route::get('/dynamic', [DynamicController::class, 'index']);


    // gallery route
    Route::get('/gallery/create', [GalleryController::class, 'create']);
    Route::post('/gallery/store', [GalleryController::class, 'store']);
    Route::get('/gallery/show/{id}', [GalleryController::class, 'show']);
    Route::get('/gallery/edit/{id}', [GalleryController::class, 'edit']);
    Route::patch('/gallery/update/{id}', [GalleryController::class, 'update']);
    Route::get('/gallery/destroy/{id}', [GalleryController::class, 'destroy']);
    Route::get('/gallery', [GalleryController::class, 'index']);

    // partner route
    Route::get('/partner/create', [PartnerController::class, 'create']);
    Route::post('/partner/store', [PartnerController::class, 'store']);
    Route::get('/partner/show/{id}', [PartnerController::class, 'show']);
    Route::get('/partner/edit/{id}', [PartnerController::class, 'edit']);
    Route::patch('/partner/update/{id}', [PartnerController::class, 'update']);
    Route::get('/partner/destroy/{id}', [PartnerController::class, 'destroy']);
    Route::get('/partner', [PartnerController::class, 'index']);

    // news route
    Route::get('/news/create', [NewsController::class, 'create']);
    Route::post('/news/store', [NewsController::class, 'store']);
    Route::get('/news/show/{id}', [NewsController::class, 'show']);
    Route::get('/news/payhistory/{id}', [NewsController::class, 'payhistory']);
    Route::get('/news/edit/{id}', [NewsController::class, 'edit']);
    Route::patch('/news/update/{id}', [NewsController::class, 'update']);
    Route::patch('/news/payfee/{id}', [NewsController::class, 'payfee']);
    Route::get('/news/destroy/{id}', [NewsController::class, 'destroy']);
    Route::get('/news', [NewsController::class, 'index']);


    // events route
    Route::get('/events/create', [EventsController::class, 'create']);
    Route::post('/events/store', [EventsController::class, 'store']);
    Route::get('/events/show/{id}', [EventsController::class, 'show']);
    Route::get('/events/edit/{id}', [EventsController::class, 'edit']);
    Route::patch('/events/update/{id}', [EventsController::class, 'update']);
    Route::get('/events/destroy/{id}', [EventsController::class, 'destroy']);
    Route::get('/events', [EventsController::class, 'index']);


    // review route
    Route::get('/review/create', [ReviewController::class, 'create']);
    Route::post('/review/store', [ReviewController::class, 'store']);
    Route::get('/review/show/{id}', [ReviewController::class, 'show']);
    Route::get('/review/edit/{id}', [ReviewController::class, 'edit']);
    Route::patch('/review/update/{id}', [ReviewController::class, 'update']);
    Route::get('/review/destroy/{id}', [ReviewController::class, 'destroy']);
    Route::get('/review', [ReviewController::class, 'index']);


    // banner route
    Route::get('/banner/create', [BannerController::class, 'create']);
    Route::post('/banner/store', [BannerController::class, 'store']);
    Route::get('/banner/show/{id}', [BannerController::class, 'show']);
    Route::get('/banner/edit/{id}', [BannerController::class, 'edit']);
    Route::patch('/banner/update/{id}', [BannerController::class, 'update']);
    Route::get('/banner/destroy/{id}', [BannerController::class, 'destroy']);
    Route::get('/banner', [BannerController::class, 'index']);

    // Route::get('/reservation', [ReservationController::class, 'index']);
    Route::get('/career', [CareerController::class, 'index']);
    Route::get('/contact', [ContactController::class, 'index']);
    Route::get('/contact/destroy/{id}', [ContactController::class, 'destroy']);
    Route::get('/donate', [ReportController::class, 'donate']);
    Route::get('/donate/destroy/{id}', [ReportController::class, 'donatedestroy']);
    Route::get('/volunteer', [ReportController::class, 'volunteer']);
    Route::get('/membership-list', [ReportController::class, 'membershipList']);
    Route::get('/donation-list', [ReportController::class, 'donationList']);
    Route::get('/volunteer/destroy/{id}', [ReportController::class, 'volunteerdestroy']);

    Route::get('/scholarship', [ReportController::class, 'scholarship']);
    Route::get('/scholarship/show/{id}', [ReportController::class, 'scholarshipshow']);
    Route::get('/scholarship/destroy/{id}', [ReportController::class, 'scholarshipdestroy']);

    Route::get('/sports', [ReportController::class, 'sports']);
    Route::get('/sports/show/{id}', [ReportController::class, 'sportsshow']);
    Route::get('/sports/destroy/{id}', [ReportController::class, 'sportsdestroy']);

    Route::get('/agriculture', [ReportController::class, 'agriculture']);
    Route::get('/agriculture/show/{id}', [ReportController::class, 'agricultureshow']);
    Route::get('/agriculture/destroy/{id}', [ReportController::class, 'agriculturedestroy']);
});
