@extends("layouts.master")

@isset($dynamic)

@section("title") {{ $dynamic->title }} @endsection
@section("meta_keywords") {{ $dynamic->meta_keywords }} @endsection
@section("meta_description") {{ $dynamic->meta_description }} @endsection

@isset($dynamic->image))
@section("share_image")assets/dynamic/meta/{{ $dynamic->image }}@endsection
@endisset


@section("additional") {!! $dynamic->additional !!} @endsection

@endisset

@section('content')



 <!-- Start Page Banner -->
        <div class="page-banner-area" @isset($dynamic->banner) style="background-image: url({{ asset('assets/dynamic/banner/'.$dynamic->banner) }});" @endisset>
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="page-banner-content">
                            <h2>Our Testimonials</h2>
                            <ul>
                                <li>
                                    <a href="{{ url('') }}">Home</a>
                                </li>
                                <li>Testimonials</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Page Banner -->
        

        <!-- Section: Testimonials -->
    <section class="layer-overlay overlay-white-2 bg-no-repeat bg-pos-center-center bg-size-contain pt-70 pb-70"
        data-tm-bg-img="images/bg/map.png" data-tm-margin-top="-90px">
        <div class="container pb-70">
            <div class="section-title1">
                <div class="row justify-content-md-center">
                    <div class="col-md-12 col-sm-12">
                        <div class="text-center">
                            <div class="tm-sc-section-title section-title">
                                <div class="title-wrapper">
                                    <span>Testimonial</span>
                                    <h3>What Clients Say About Us</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-content">
                <div class="row" data-animation="fadeIn">
                    @foreach($testimonials as $item)
                    <div class="col-md-4 col-lg-4 col-sm-6">
                        <div class="testimonial-item">
                            <div class="icon">
                                <i class="flaticon-left-quotes-sign"></i>
                            </div>
                            <div class="star-rating"> <span data-tm-width="90%"></span></div>
                            <span class="position">
                                @for ($i = 0; $i < $item->rating; $i++)
                                    <span class="bx bx-star"></span>
                                @endfor
                                <span class="trt">({{ $item->rating }}.0)</span>
                            </span>
                            <div class="author-text"> {{ $item->review }} </div>
                            <br>
                            <div class="author-info1 clearfix">
                                <h5 class="name">{{ $item->name }}, <span>(<small class="job-position">{{ $item->role }}</small>)</span></h5>
                                
                            </div>
                            <div class="author-thumb">
                                <img class="rounded-circle" style="width:75px" src="{{ !empty($item->image) ? asset($item->image) : asset('assets/images/testimonials/1.png') }}"
                                                    alt="{{ $item->name }}" />
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>

   
@endsection       