@extends("layouts.master")

@isset($dynamic)

@section("title") {{ $dynamic->title }} @endsection
@section("meta_keywords") {{ $dynamic->meta_keywords }} @endsection
@section("meta_description") {{ $dynamic->meta_description }} @endsection
@isset($dynamic->image))
@section("share_image")assets/dynamic/meta/{{ $dynamic->image }}@endsection
@endisset


@section("additional") 
{!! $dynamic->additional !!}



@endsection

@endisset

@section('content')
<main>
<style>
	
	.pb-2{
	padding-bottom:8px;
	}
</style>
    <div class="slider-area">
        <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-6 col-md-6">
                        <div class="hero-caption hero-caption2">
                            <h2>Scholarship</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


        <section class="volunteer sec-padd">
			 
			
            <div class="container">
				
                <div class="form-sec bg-1 p-4">
                    <div class="section-tittle text-center mb-60">
                        <h2>Scholarship <span1 class="text-theme"> Registration </span1>
                        </h2>
                    </div>

                    <div class="default-form-area">
                        <form id="contact-form" name="contact_form" class="default-form"
                            action="{{ url('scholarship') }}" method="post" enctype="multipart/form-data">
                            @csrf
							<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="default-form-bg">
            <div class="row clearfix w-100">
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="name">Your Name *</label>
                        <input type="text" name="name" class="form-control" value="" placeholder="Your Name *" required="" aria-required="true">
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="father_name">Your Father Name *</label>
                        <input type="text" name="father_name" class="form-control" value="" placeholder="Your Father Name *" required="" aria-required="true">
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="gender">Select Gender *</label>
                        <select name="gender" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select Gender*</option>
                            <option value="Male">Male</option>
                            <option value="Female">Female</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="dob">DOB</label>
                        <input type="text" name="dob" id="dob" datetimepicker class="form-control" value="" placeholder="DOB">
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="class">Class</label>
                        <input type="text" name="class" class="form-control" value="" placeholder="Class">
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="phone">Phone Number *</label>
                        <input type="text" name="phone" id="mobile" class="form-control" value="" placeholder="Phone Number *" required>
                        <span id="mobileError" style="color: red;"></span>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="email">Email Id *</label>
                        <input type="email" name="email" id="email" class="form-control required email" value="" placeholder="Email Id *" required="" aria-required="true">
                        <span id="emailError" style="color: red;"></span>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="religion">Select Religion *</label>
                        <select name="religion" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select Religion*</option>
                            <option value="Hindu">Hindu</option>
                            <option value="Muslim">Muslim</option>
                            <option value="Sikh">Sikh</option>
                            <option value="Christian">Christian</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="adhar_no">Adhar Number</label>
                        <input type="number" name="adhar_no" class="form-control" value="" placeholder="Adhar Number">
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="caste">Select Caste *</label>
                        <select name="caste" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select Caste*</option>
                            <option value="General">General</option>
                            <option value="OBC">OBC</option>
                            <option value="EWS">EWS</option>
                            <option value="SC-ST">SC-ST</option>
                        </select>
                    </div>
                </div>

				
				
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="address">Address</label>
                        <input type="text" name="address" class="form-control" value="" placeholder="Address">
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="state">Select State *</label>
                        <select name="state" id="state" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select State*</option>
                            <!-- Options for states here -->
							 @foreach($states as $state)
                                                        <option value="{{ $state->state_id }}">{{ $state->state_title }}</option>
                                                        @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="district">Select District *</label>
                        <select name="district" id="district" class="form-control" value="" required="" aria-required="true">
                            <option value="">Select District*</option>
                            <!-- Options for districts here -->
                        </select>
                    </div>
                </div>

				
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="pincode">Pincode *</label>
                        <input type="text" name="pincode" class="form-control" value="" placeholder="Pincode *" required>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="exam_center">Select Exam Center City *</label>
                        <select name="exam_center" id="exam_center" class="form-control" value="" required aria-required="true">
                            <option value="">Select Exam Center City*</option>
                            <!-- Options for exam center cities here -->
							  @foreach($exam_center as $center)
                                                        <option value="{{ $center->name }}">{{ $center->name }}</option>
                                                        @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 col-xs-12">
                    <div class="form-group">
                        <label for="fileInput">Payment Receipt</label>
                        <div class="custom-file">
                            <input type="file" name="receipt" class="custom-file-input form-control" id="fileInput">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

							<div class="row my-4">
            <div class="col-md-4">
                <div class="card p-4" style="height: 100%">
                    <img src="{{ asset('assets/img/phonepay-qr.png') }}" class="card-img-top" alt="GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION QR">
                    <div class="card-body">
                        <p class="card-text text-center">Scan QR Code for Payment</p>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card" style="height: 100%">
                    <div class="card-body p-4">
						<h2 class="display-4">Payment Details for GMM EDUCATIONAL TRUST AND WELFARE ASSOCIATION</h2>
						<br>
                        <h5 class="card-title pb-2"><strong>Account Number:</strong> 9962003800002766</h5>
                        <h5 class="card-title pb-2"><strong>Ifsc Code:</strong> PUNB0996200</h5>
                        <h5 class="card-title pb-2"><strong>Account Holder Name:</strong> Rohit Rana</h5>
                        <h5 class="card-title pb-2"><strong>UPI Address:</strong> <b>ranarohit194@ybl</b></h5>
                    </div>
                </div>
            </div>
        </div>
							
                            <div class="col-md-12 col-sm-12 col-xs-12 mt-3">
                                <div class="form-group center">
                                    <button class="thm-btn" type="submit" data-loading-text="Please wait...">submit
                                        now</button>
                                </div>
                            </div>
							<div class="col-md-12 col-sm-12 col-xs-12">
								<p>
									<b>नोट:</b> पेमेंट करने के लिए नीचे दिए गए बार कोड या upi का प्रयोग करे व स्क्रीनशॉट अपलोड कर
								</p>
                        	</div>

                        </form>
                    </div>
                </div>
            </div>
			
		
        </section>


</main>

        @endsection     
@section('scripts')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.min.css">

      <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.full.min.js"></script>
<script>
    var jq = jQuery.noConflict();
</script>
    <script>
        jq(document).ready(function() {
            jq("#dob").datetimepicker({
                timepicker: false, // Disable time selection
                format: "Y-m-d",
                yearStart: 1900,   // Start year for the year dropdown
                yearEnd: new Date().getFullYear() // End year for the year dropdown
            });
        });
    </script>
 <script>
        jq(document).ready(function() {
            jq("form").submit(function(event) {
                var email = jq("#email").val();
                var mobile = jq("#mobile").val();
                var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
                var mobilePattern = /^[0-9]{10}$/;

                jq("#emailError").text("");
                jq("#mobileError").text("");

                if (!emailPattern.test(email)) {
                    event.preventDefault();
                    jq("#emailError").text("Invalid email format");
                }

                if (!mobilePattern.test(mobile)) {
                    event.preventDefault();
                    jq("#mobileError").text("Invalid mobile number format");
                }
            });
        });
    </script>

    
<script>
    jq(document).ready(function() {
        jq("#state").change(function() {
            var state_id = jq("#state").val();
            jq.get("{{ url('district?state_id=') }}"+state_id).done(function(data) {
                jq("#district").html(data);
            });
        });
    });
    </script> 
   
@endsection