@extends("layouts.master")

@isset($dynamic)

@section("title") {{ $dynamic->title }} @endsection
@section("meta_keywords") {{ $dynamic->meta_keywords }} @endsection
@section("meta_description") {{ $dynamic->meta_description }} @endsection

@isset($dynamic->image))
@section("share_image")assets/dynamic/meta/{{ $dynamic->image }}@endsection
@endisset


@section("additional") {!! $dynamic->additional !!} @endsection

@endisset

@section('content')

<main>

    <div class="slider-area">
        <div class="slider-height2 slider-bg4 hero-overly d-flex align-items-center" @isset($dynamic->banner) style="background-image: url({{ asset('assets/dynamic/banner/'.$dynamic->banner) }});" @endisset>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-6 col-md-6">
                        <div class="hero-caption hero-caption2">
                            <h2>Our Projects</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="services-area1 bg-1 section-padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 col-md-10 col-sm-11">
                    <div class="section-tittle text-center mb-60">
                        <h2>The Causes <span1 class="text-theme"> We Care About</span1>
                        </h2>
                    </div>
                </div>
            </div>
            <div class="row">
                
                @foreach ($projects as $item)

                <div class="col-lg-4 col-md-6 col-sm-6">
                    <div class="properties pb-30">
                        <div class="properties-card">
                            <div class="properties-img">
                                <a href="{{ url('project/' . $item->slug) }}"><img src="{{ asset('/assets/project/grid/' . $item->image) }}"
                                        alt="{{ $item->title }}"></a>
                            </div>
                            <div class="wrap-wrapper">
                                <div class="properties-caption">
                                    <h3><a href="{{ url('project/' . $item->slug) }}">{{ $item->title }}</a></h3>
                                    <p>
                                        {{ $item->shortDescription() }}
                                    </p>
                                </div>
                                <div class="properties-footer d-flex justify-content-between align-items-center">
                                    <div class="class-day">
                                        <a href="{{ url('project/' . $item->slug) }}" class="btn">Learn More</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        @endforeach
    </div>
</div>
</section>
    <!-- End project Area -->


@endsection       