<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta content="@yield('site_name', $settings->site_name)" name="author" />
    <meta name="theme-color" content="@yield('theme_color', $settings->theme_color)" />
    <link rel="shortcut icon" href="{{ asset('') }}@yield('favicon', $settings->favicon)" type="image/png">
    <link rel="apple-touch-icon" href="{{ asset('') }}@yield('favicon', $settings->favicon)" />
    <meta property="og:type" content="website" />
    <meta name="og_site_name" property="og:site_name" content="@yield('site_name', $settings->site_name)" />
    <meta name="twitter:app:country" content="ae">
    <meta name="google-site-verification" content="YQ8UiyGEaZKqWHvQF7TqPGS-4WidqwYzUXI7Oq50x2w"  />


    <title>@yield('title', $settings->title)</title>
    <meta content="@yield('title', $settings->title)" name="title" />
    <meta content="@yield('meta_keywords', $settings->meta_keywords)" name="keyword" />
    <meta content="@yield('meta_description', $settings->meta_description)" name="description" />
    <link rel="canonical" href="{{ url()->current() }}" />


    <meta name="og:title" content="@yield('title', $settings->title)" />
    <meta name="og:description" content="@yield('meta_description', $settings->meta_description)" />
    <meta property="og:image" content="{{ asset('/') }}@yield('share_image', $settings->share_image)">

    <meta name="twitter:title" content="@yield('title', $settings->title)">
    <meta name="twitter:description" content="@yield('meta_description', $settings->meta_description)">
    <meta property="twitter:image" content="{{ asset('/') }}@yield('share_image', $settings->share_image)" />

    <meta name="twitter:app:name:googleplay" content="@yield('app_name', $settings->app_name)">
    <meta name="twitter:app:id:googleplay" content="@yield('app_id', $settings->app_id)">
    <meta name="twitter:app:url:googleplay" content="https://play.google.com/store/apps/details?id=@yield('app_id', $settings->app_id)">


    @yield('additional')

    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/owl.carousel.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/slicknav.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/progressbar_barfiller.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/animate.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/fontawesome-all.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/themify-icons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/slick.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/nice-select.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/imagelightbox.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/css/main.css') }}" />
    
    <link rel="stylesheet" href="{{ config('app.admin.asset') . 'sweetalert/sweetalert.min.css' }}">

    <style>
        :root {
            --primary-color: @yield('theme_color', $settings->theme_color)

             !important;

            --secondary-color: @yield('secondary_color', $settings->secondary_color)

             !important;
        }
    </style>
    <!-- ✅ For Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>

<body>
    @include('includes.header')

    @yield('content')

    @include('includes.footer')
    <div class="whatsapp-fixed">
        <a href="https://web.whatsapp.com/send/?phone={{ preg_replace('/[^\dxX]/', '', $settings->whatsapp_no) }}&amp;text&amp;type=phone_number&amp;app_absent=0"
            class="float whatsapp-link" target="_blank">
            <img src="{{ asset('assets/img/whatsapp-48x48.png') }}" width="48" height="48">
        </a>
    </div>
	
  <div id="back-top">
    <a title="Go to Top" href="#"> <i class="fas fa-level-up-alt"></i></a>
  </div>

  <script src="{{ asset('assets/js/vendor/modernizr-3.5.0.min.js') }}"></script>
  <script src="{{ asset('assets/js/vendor/jquery-1.12.4.min.js') }}"></script>
  <script src="{{ asset('assets/js/popper.min.js') }}"></script>
  <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>

  <script src="{{ asset('assets/js/owl.carousel.min.js') }}"></script>
  <script src="{{ asset('assets/js/imagelightbox.min.js') }}"></script>
  <script src="{{ asset('assets/js/slick.min.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.slicknav.min.js') }}"></script>

  <script src="{{ asset('assets/js/wow.min.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.magnific-popup.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.nice-select.min.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.counterup.min.js') }}"></script>
  <script src="{{ asset('assets/js/waypoints.min.js') }}"></script>
  <script src="{{ asset('assets/js/barfiller.js') }}"></script>

  {{-- <script src="{{ asset('assets/js/contact.js') }}"></script> --}}
  <script src="{{ asset('assets/js/jquery.form.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
  <script src="{{ asset('assets/js/mail-script.js') }}"></script>
  <script src="{{ asset('assets/js/jquery.ajaxchimp.min.js') }}"></script>

  <script src="{{ asset('assets/js/plugins.js') }}"></script>
  <script src="{{ asset('assets/js/main.js') }}"></script>
  


@yield('scripts')
	

    @if ($settings->home_popup_status == 1)



    <style>
        .div-fpbox {
            padding: 5px 15px;
        }

        .rating i.fa {
            color: #ffca42;
        }

        #footer-popup {
            display: none;
            position: fixed;
            bottom: 2%;
            left: 2%;
            width: 85%;
            max-width: 325px;
            background-color: #fff;
            box-shadow: 0 0 5px var(--secondary-color);
            border-radius: 10px;
        }


        .div-fpbox h5 {
            margin-top: 0;
            margin-bottom: 2px;
            color: var(--primary-color) !important;
            display: flex;
            align-items: center;
            height: 100%;
        }

        #footer-popup p{
            margin-bottom: 2px;
        }

        #footer-popup #testimonialText {
            text-overflow: ellipsis;
            overflow: hidden;
            display: -webkit-box;
            -webkit-line-clamp: 4;
            -webkit-box-orient: vertical;
            margin-bottom: 2px;
        }

        #footer-popup #testimonialText.extratext {
            text-overflow: none;
            display: block;
        }

        #footer-popup .button {
            border: 1px solid #fff;
            background-color: var(--primary-color);
            color: #fff;
            border: none;
            padding: 0px;
            width: 100%;
            display: block;
            border-radius: 50px;
            cursor: pointer;
            text-align: center;
        }
        

        #footer-popup button:hover {
            background-color: var(--secondary-color);
        }

        .read-more-btn {
            padding: 0;
            border: none;
            background: transparent;
            color: #000;
            width: 100%;
            display: block;
            text-align: right;
            font-size: 14px;
        }

        .read-more-btn:hover,
        .read-more-btn:active {
            color: #000;
        }

        .float{
                bottom: 85px;
    right: 25px;
    left: auto;
        }
    </style>
     

    <div id="footer-popup" style="display: block;">
        <div style="position: absolute;right:0;margin-top: -30px;">
            <button onclick="rClose()" class="btn btn-sm rounded-circle"> <i class="fa-times-circle fas text-danger"></i>
            </button>
        </div>
        <div class="div-fpbox">
            <div id="testimonialText">
                {!! $settings->home_popup !!}
            </div>
        </div>
        <a href="#newsletter-popup" data-bs-toggle="modal" target="_blank" class="button">Know More</a>
    </div>



        <div id="newsletter-popup" class="modal fade" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-bottom: 2px solid var(--clr-main);">
                    <div class="modal-body">
                        <a href="#" class="btn btn-sm btn-danger close float-end">x</a>
                        {!! $settings->home_popup !!}
                    </div>
					<div class="modal-footer justify-content-around">
						<a href="{{ url('contact') }}" class="btn btn-solid"> <i class="fa fa-paper-plane"></i> &nbsp; Enquiry</a>
						<a href="https://web.whatsapp.com/send/?phone={{ preg_replace('/[^\dxX]/', '', $settings->contact_fax) }}&text&type=phone_number&app_absent=0" target="_blank" class="btn btn-outline whatsapp-link"> <i class="fab fa-whatsapp"></i> &nbsp; Whatsapp</a>
					</div>
                </div>
            </div>
        </div>

        <script>
            $(document).ready(function() {
                    $(".openHomePopup").click(function() {
                        $('#newsletter-popup').modal('show');
                    });
                    
                    $('.close').click(function() {
                        $('#newsletter-popup').modal('hide');
            });
            
            
            if($(window).width() < 768) {
                
                $(".whatsapp-link").attr("href","https://wa.me/{{ preg_replace('/[^\dxX]/', '', $settings->contact_fax) }}");
                $("#footer-popup").css("max-width","245px");
                
            }
            
            
            });

             function rClose() {
            $("#footer-popup").hide();
        }
        </script>
    @endif

    <!-- Sweet Alert -->
    <script src="{{ config('app.admin.asset') . 'sweetalert/sweetalert.min.js' }}"></script>

    @if (session()->has('success'))
        <script>
            $(function() {
                Swal.fire({
                    title: "Success!",
                    html: "{{ session()->get('success') }}",
                    type: "success",
                    showConfirmButton: true,
                    timer: 5000
                });
            });
        </script>
    @endif

    @if (Session::has('flash'))
        <?php $flash = Session::get('flash');
        Session::forget('flash'); ?>

        <script>
            $(function() {
                Swal.fire({
                    html: "{{ $flash['message'] }}",
                    type: "{{ $flash['msg_type'] }}",
                    title: "{{ $flash['error_type'] }}",
                    showConfirmButton: true,
                    timer: 5000
                });
            });
        </script>
    @endif


    @if (session()->has('error'))
        <script>
            $(function() {
                Swal.fire({
                    title: "Error!",
                    html: "{{ session()->get('error') }}",
                    type: "error",
                    showConfirmButton: true,
                    timer: 5000
                });
            });
        </script>
    @endif

    @if ($errors->any())
        <script>
            $(function() {
                Swal.fire({
                    title: "Error!",
                    html: "<ul class='text-left m-auto d-block'> @foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach </ul>",
                    type: "error",
                    showConfirmButton: true,
                });
            });
        </script>
    @endif


	

</body>

</html>
