@extends("layouts.master")

@isset($dynamic)

@section("title") {{ $dynamic->title }} @endsection
@section("meta_keywords") {{ $dynamic->meta_keywords }} @endsection
@section("meta_description") {{ $dynamic->meta_description }} @endsection

@isset($dynamic->image))
@section("share_image")assets/dynamic/meta/{{ $dynamic->image }}@endsection
@endisset


@section("additional") {!! $dynamic->additional !!} @endsection

@endisset

@section('content')

 <!-- Start Page Banner -->
        <div class="page-banner-area" @isset($dynamic->banner) style="background-image: url({{ asset('assets/dynamic/banner/'.$dynamic->banner) }});" @endisset>
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="page-banner-content">
                            <h2>Our Events</h2>
                            <ul>
                                <li>
                                    <a href="{{ url('') }}">Home</a>
                                </li>
                                <li>Events</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Page Banner -->
        

    <!-- Start Events Area -->
<section class="services-area bg-f3f3f3 pt-100 pb-70">
    <div class="container">
        <div class="section-title">
            <span>Our Events</span>
            <h3>Our Events</h3>
            
        </div>
            <div class="row">
                @foreach ($events as $item)
        <div class="col-lg-4 col-md-6">
            <div class="single-services-box" data-animation="zoomIn">
                <div class="image-box"><img loading="lazy" src="{{ asset('/assets/events/grid/' . $item->image) }}" alt="{{ $item->title }}" /></div>
                <div class="content">
                    
                <h3>{{ $item->title }}</h3>
                <p>{{ $item->shortDescription() }}</p>
                <a href="{{ url('events/' . $item->slug) }}">Read More</a>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
</section>


@endsection       