@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Add User
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Add User</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Add User </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">User Add</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'user' }}">
                                    <i class="fa fa-list"></i> User List</a>
                            </div>

                            <form action="{{ config('app.admin.url') . 'user/store' }}" method="POST" class="form-style3"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">

                                    <div class="row">
                                        
                                        <div class="col-md-6 mb-2 mt-0">
                                            <div class="form-group">
                                                    <label for="exampleInputEmail1">User Photo</label>
                                                    <input type="file" name="photo" class="dropify"  data-max-file-size="1M" />
                                            </div>

                                        </div>
                                        
                                        <div class="col-md-6 mb-2 mt-0">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">User Name</label>
                                                <input type="text" name="name" class="form-control"
                                                    placeholder="User Name">
                                            </div>

                                       
                                            
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Email</label>
                                                <input type="text" name="email" class="form-control"
                                                    placeholder="User email">
                                            </div>

                                        
                                            <div class="form-group">
                                                <label for="exampleInputEmail1"> Phone</label>
                                                <input type="text" name="name" class="form-control"
                                                    placeholder="User Phone">
                                            </div>

                                        </div>
                                        <div class="col-md-6 mb-2 mt-0">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1"> Address</label>
                                                <input type="text" name="address" class="form-control"
                                                    placeholder="User Address">
                                            </div>

                                        </div>
                                        <div class="col-md-6 mb-2 mt-0">


                                            <div class="form-group">
                                                <label for="exampleInputEmail1"> Role</label>
                                                <select class="form-control" name="role" id="role">
                                                    <option value="" selected>Select one</option>
                                                    <option value="admin">Admin</option>
                                                    <option value="manufacuring">Manufacuring</option>
                                                    <option value="dispatcher">Dispatcher</option>
                                                    <option value="agent">Agent</option>
                                                    <option value="accountant">Accountant</option>
                                                </select>
                                            </div>

                                        </div>

                                          <div class="col-md-6 mb-2 mt-0">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="1">Active</option>
                                                    <option value="0">Disabled</option>
                                                </select>
                                            </div>

                                        </div>

                                        <div class="col-md-6 mb-2 mt-0">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1"> Password</label>
                                                <input type="text" name="password" class="form-control"
                                                    placeholder="User Password">
                                            </div>
</div>
                                        
                                        <div class="col-md-6 mb-2 mt-0">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Confirm Password</label>
                                                <input type="text" name="confiirm_password" class="form-control"
                                                    placeholder="User Password">
                                            </div>

                                        </div>
                                      
                                    </div>
                                </div>

                                <div class="card-footer text-center">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
