@extends('admin.layouts.master')
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Add Review</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Add Review </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Review Add</h2>
                                <a class="btn btn-dark text-white btn-sm float-right" href="{{ config('app.admin.url') . 'review' }}">
                                    <i class="fa fa-plus"></i> Review List</a>
                            </div>


                            <form action="{{ config('app.admin.url') . 'review/store' }}" method="POST" class="form-style3"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Name</label>
                                                <input type="text" name="name" class="form-control"
                                                    placeholder="Name">
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Role</label>
                                                <input type="text" name="role" class="form-control"
                                                    placeholder="Role">
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="image">Image</label>
                                                <input type="file" name="image" id="image" class="dropify"
                                                    accept="image/png, image/jpeg, image/jpg, image/gif, image/svg"
                                                    data-max-file-size="2M">
                                            </div>
                                        </div>


                                        {{-- <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="review_image">Review Image</label>
                                                <input type="file" name="review_image" id="review_image"
                                                    class="form-control" data-max-file-size="2M">
                                            </div>
                                        </div> --}}

                                        <div class="col-md-6">

                                            
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Rating</label>
                                                <select type="text" name="rating" class="form-control">
                                                    <option value="">-- Select Review --</option>
                                                    <option value="5">5 star</option>
                                                    <option value="4">4 star</option>
                                                    <option value="3">3 star</option>
                                                    <option value="2">2 star</option>
                                                    <option value="1">1 star</option>
                                                    <option value="0">0 star</option>
                                                </select>
                                            </div>

                                            <div class="form-group">
                                                <label for="review">Review Content</label>
                                                <textarea name="review" id="editor1" value="{{ old('review') }}" placehoder="Enter Review" class="form-control"></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="1">Active</option>
                                                    <option value="0">Disabled</option>
                                                </select>
                                            </div>
                                       
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Home Show</label>
                                                <select name="home" class="form-control">
                                                    <option value="1">Active</option>
                                                    <option value="0" selected>Disabled</option>
                                                </select>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
