@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Donate List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Donate List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Donate List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Donate List</h2>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            {{-- <th>User Id</th> --}}
                                            <th>Email</th>
                                            <th>Mobile Number</th>
                                            <th>Payment Type</th>
                                            <th>Amount</th>
                                            <th>UTR Number</th>
                                            <th>Screenshot</th> <!-- New column -->
                                            <th>Payment Status</th>
                                            <th>Addon</th>
                                            {{-- <th>Action</th> --}}
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($donations as $key => $donation)
                                            <tr>
                                                <td>{{ $key + 1 }}.</td>
                                                <td>{{ $donation['name'] }}</td>
                                                {{-- <td>{{ $donation['user_id'] }}</td> --}}
                                                <td>{{ $donation['email'] }}</td>
                                                <td>{{ $donation['phone'] }}</td>
                                                <td>{{ $donation['payment_type'] }}</td>
                                                <td>{{ $donation['amount'] }}</td>
                                                <td>{{ $donation['utr_number'] }}</td>

                                                <!-- Screenshot column -->
                                                <td>
                                                    @if ($donation->screenshot)
                                                        <a href="{{ asset($donation->screenshot) }}" target="_blank">
                                                            <img src="{{ asset($donation->screenshot) }}" alt="Screenshot"
                                                                style="width:50px; height:auto; border-radius:5px;">
                                                        </a>
                                                    @else
                                                        N/A
                                                    @endif
                                                </td>

                                                <td>
                                                    <select
                                                        class="form-control donation-status
                                                        {{ $donation->status == 'confirmed' ? 'bg-success text-white' : ($donation->status == 'rejected' ? 'bg-danger text-white' : 'bg-warning text-dark') }}"
                                                        onchange="updateStatus(this)" data-id="{{ $donation->id }}">

                                                        <option value="confirmed"
                                                            {{ $donation->status == 'confirmed' ? 'selected' : '' }}>
                                                            Confirmed</option>
                                                        <option value="pending"
                                                            {{ $donation->status == 'pending' ? 'selected' : '' }}>Pending
                                                        </option>
                                                        <option value="rejected"
                                                            {{ $donation->status == 'rejected' ? 'selected' : '' }}>
                                                            Rejected</option>
                                                    </select>
                                                </td>

                                                <td>{{ $donation['created_at']->format('d/m/Y') }}</td>
                                                {{-- <td>
                                                    <a class="btn btn-danger btn-sm my-1"
                                                        href="{{ config('app.admin.url') . 'donate/destroy/' . encrypt($donation->id) }}"
                                                        title="Delete"><i class="fa fa-trash"></i></a>
                                                </td> --}}
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

<script>
    function updateStatus(selectElement) {
        let id = selectElement.getAttribute('data-id');
        let status = selectElement.value;
        let formData = new FormData();
        formData.append('id', id);
        formData.append('status', status);
        fetch("{{ route('donation.updateStatus') }}", {
                method: "POST",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    alert("Status updated successfully!");
                } else {
                    alert("Failed to update status!");
                }
            })
            .catch(err => console.error(err));
    }
</script>
