@extends(config('app.admin.view').".layouts.master")

@section('title')
    Donate List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Donate List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Donate List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Donate List</h2>
                                
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Mobile Number</th>
                                            <th>Address</th>
                                            <th>City</th>
                                            <th>Payment Reciept</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($donates as $key=> $donate)

                                        <tr>
                                            <td>{{ $key+1 }}.</td>
                                            <td>{{ $donate['name'] }}</td>
                                            <td>{{ $donate['email'] }}</td>
                                            <td>{{ $donate['phone'] }}</td>
                                            <td>{{ $donate['address'] }}</td>
                                            <td>{{ $donate['city'] }}</td>
                                            <td><a href="{{ asset('donate/reciept/' . $donate['reciept']) }}" target="new"
                                            class="btn btn-default">Go to File</a></td>
											<td>{{ $donate['created_at']->format('d/m/Y') }}</td>
                                            <td>
<a class="btn btn-danger btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'donate/destroy/'.encrypt($donate->id)) }}"
                                                    title="Delete"><i class="fa fa-trash"></i></a>
</td>
                                         
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
