@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Agriculture List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Agriculture List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Agriculture List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Agriculture List</h2>

                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Father's / Husband Name</th>
                                            <th>Aadhar Number</th>
                                            <th>Mobile Number</th>
                                            <th>Address</th>
                                            <th>Crop/Product Name</th>
                                            <th>Quantity</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($agriculture as $key => $agriculture)
                                            <tr>
                                                <td>{{ $key + 1 }}.</td>
                                                <td>{{ $agriculture['name'] }}</td>
                                                <td>{{ $agriculture['fh_name'] }}</td>
                                                <td>{{ $agriculture['adhar_no'] }}</td>
                                                <td>{{ $agriculture['phone'] }}</td>
                                                <td>{{ $agriculture['address'] }}</td>
                                                <td>{{ $agriculture['corps_name'] }}</td>
                                                <td>{{ $agriculture['quantity'] }}</td>

                                                <td>{{ $agriculture['created_at']->format('d/m/Y') }}</td>
                                                <td>
                                                    <a class="btn btn-info btn-sm my-1"
                                                        href="{{ config('app.admin.url') . 'agriculture/show/' . encrypt($agriculture->id) }}"
                                                        title="Show"><i class="fa fa-eye"></i></a>

                                                    <a class="btn btn-danger btn-sm my-1"
                                                        href="{{ config('app.admin.url') . 'agriculture/destroy/' . encrypt($agriculture->id) }}"
                                                        title="Delete"><i class="fa fa-trash"></i></a>
                                                </td>

                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
