@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Edit Project
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Edit Project</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Edit Project </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">


                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Edit Project</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'project' }}">
                                    <i class="fa fa-list"></i> Project List</a>
                            </div>

                            <form action="{{ config('app.admin.url') . 'project/update/' . encrypt($project->id) }}"
                                method="POST" class="form-style3" enctype="multipart/form-data">
                                @csrf
                                @method('PATCH')
                                <div class="card-body">

                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Project Name</label>
                                        <input type="text" name="name" class="form-control"
                                            placeholder="Project Name" value="{{ $project->name }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="banner">Banner Image (1920 X 700) px</label>
                                        <input type="file" name="banner" id="banner" class="dropify mb-2"
                                            accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp"
                                            data-default-file="{{ asset('assets/project/banner/' . $project->banner) }}">
                                        <a href="{{ asset('assets/project/banner/' . $project->banner) }}" target="new"
                                            class="btn btn-default form-control">Go to File</a>
                                    </div>

                                    <div class="form-group">
                                        <label for="image"> Image</label>
                                        <input type="file" name="image" id="image" class="dropify mb-2"
                                            accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp"
                                            data-default-file="{{ asset('assets/project/meta/' . $project->image) }}"
                                            data-max-file-size="2M">
                                        <a href="{{ asset('assets/project/meta/' . $project->image) }}" target="new"
                                            class="btn btn-default form-control">Go to File</a>
                                    </div>

                                    {{-- <div class="form-group">
                                        <label for="catalogue"> Catalogue</label>
                                        <input type="file" name="catalogue" id="catalogue" class="dropify mb-2"
                                           
                                            data-default-file="{{ asset('assets/project/catalogue/' . $project->catalogue) }}">
                                        <a href="{{ asset('assets/project/catalogue/' . $project->catalogue) }}" target="new"
                                            class="btn btn-default form-control">Go to File</a>
                                    </div> --}}

                                    <div class="form-group">
                                        <label for="title">Title</label>
                                        <input type="text" class="form-control" id="title" name="title"
                                            value="{{ $project->title }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title">Keywords</label>
                                        <input type="text" class="form-control" id="meta_keywords" name="meta_keywords"
                                            value="{{ $project->meta_keywords }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="title">Additional (additional meta tags)</label>
                                        <textarea class="form-control" id="additional" name="additional">{{ $project->additional }}</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="title">Description</label>
                                        <textarea class="form-control" rows="6" id="meta_description" name="meta_description">{{ $project->meta_description }}</textarea>
                                    </div>
                                <div class="form-group">
                                    <label for="title">Page Detail</label>
                                    <textarea class="form-control" rows="6" id="details" name="details">{{ $project->details }}</textarea>
                                </div>
                                <div class="form-group">
                            <label for="exampleInputEmail1">Home Status</label>
                            <select name="home" class="form-control">
                                <option value="1" @if ($project->home == 1) selected @endif>Active</option>
                                <option value="0" @if ($project->home == 0) selected @endif>Disabled</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Status</label>
                            <select name="status" class="form-control">
                                <option value="1" @if ($project->status == 1) selected @endif>Active</option>
                                <option value="0" @if ($project->status == 0) selected @endif>Disabled</option>
                            </select>
                        </div>
                    </div>
                <div class="card-footer text-right">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                </form>
            </div>
    </div>
    </div>
    </div>
    </section>
    </div>
    
    <script>
        $(document).ready(function () {
            $('#details').summernote({
              'height':'300px'
            });
        });
    </script>
@endsection
