@extends(config('app.admin.view').".layouts.master")

@section('title')
    Add Project
@endsection

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Add Project</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Add Project </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Project Add</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'project' }}">
                                    <i class="fa fa-list"></i> Project List</a>
                            </div>

                            <form action="{{ config('app.admin.url') . 'project/store' }}" method="POST"
                                class="form-style3" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-md-6">
                                    

                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Project Name</label>
                                        <input type="text" name="name" class="form-control"
                                            placeholder="Project Name">
                                    </div>
                                    

                                    <div class="form-group">
                                        <label for="banner">Banner Image (1920 X 700) px</label>
                                        <input type="file" name="banner" id="banner" class="dropify"
                                            accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp" >
                                    </div>

                                    <div class="form-group">
                                        <label for="image">Image</label>
                                        <input type="file" name="image" id="image" class="dropify"
                                            accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp"
                                            data-max-file-size="2M">
                                    </div>
                                    {{-- <div class="form-group">
                                        <label for="catalogue">Catalogue</label>
                                        <input type="file" name="catalogue" id="catalogue" class="dropify"
                                            >
                                    </div> --}}
                                    </div>
                                    <div class="col-md-6">

                                    <div class="form-group">
                                        <label for="title">Title</label>
                                        <input type="text" class="form-control" id="title" name="title"
                                            value="{{ old('title') }}">
                                    </div>
                                  
                                    <div class="form-group">
                                        <label for="title">Keywords</label>
                                        <input type="text" class="form-control" id="meta_keywords"
                                            name="meta_keywords" value="{{ old('meta_keywords') }}">
                                    </div>
                                   
                                    <div class="form-group">
                                        <label for="title">Additional (additional meta tags)</label>
                                        <textarea class="form-control" id="additional"
                                            name="additional">{{ old('additional') }}</textarea>
                                    </div>
                                   
                                    <div class="form-group">
                                        <label for="title">Description</label>
                                        <textarea class="form-control" id="meta_description"
                                            name="meta_description">{{ old('meta_description') }}</textarea>
                                    </div>

                                     <div class="form-group">
                                        <label for="exampleInputEmail1">Home Status</label>
                                        <select name="home" class="form-control">
                                            <option value="1">Active</option>
                                            <option value="0">Disabled</option>
                                        </select>
                                    </div>

                                     <div class="form-group">
                                        <label for="exampleInputEmail1">Status</label>
                                        <select name="status" class="form-control">
                                            <option value="1">Active</option>
                                            <option value="0">Disabled</option>
                                        </select>
                                    </div>

                                    </div>
                                    </div>
                                    
                                    <div class="col-md-12">
                                       
                                   
                                    <div class="form-group hd">
                                        <label for="title">Page Detail</label>
                                        <textarea class="form-control" id="details"
                                            name="details">{{ old('details') }}</textarea>
                                    </div>
                                    </div>
                                </div>

                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script>
        $(document).ready(function () {
            $('#project2').change(function(){
                var abcd=$(this).val();
                if(abcd==1){
                    $('.hd').show();
                }
                else{
                    $('.hd').hide();
                }
            });
        });
    </script>

<script>
        $(document).ready(function () {
            $('#details').summernote({
              'height':'300px'
            });
        });
    </script>
@endsection
