@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Donation History
@endsection

@section('content')
    <div class="content-wrapper">

        <!-- Content Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Donation History</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Donation History </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Donation History</h2>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            {{-- <th>User ID</th> --}}
                                            <th>Donor Name</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Amount</th>
                                            <th>Payment Type</th>
                                            <th>UTR Number</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Receipt</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($donations as $key => $donation)
                                            <tr>
                                                <td>{{ $key + 1 }}.</td>
                                                {{-- <td>{{ $donation->user_id }}</td> --}}
                                                <td>{{ $donation->name }}</td>
                                                <td>{{ $donation->email }}</td>
                                                <td>{{ $donation->phone }}</td>
                                                <td>₹{{ number_format($donation->amount, 2) }}</td>
                                                <td>{{ ucfirst($donation->payment_type) }}</td>
                                                <td>{{ $donation->utr_number ?? '-' }}</td>
                                                <td>
                                                    <span
                                                        class="badge 
                                                    {{ $donation->status == 'confirmed' ? 'badge-success' : ($donation->status == 'rejected' ? 'badge-danger' : 'badge-warning') }}">
                                                        {{ ucfirst($donation->status) }}
                                                    </span>
                                                </td>
                                                <td>{{ $donation->created_at->format('d/m/Y h:i A') }}</td>
                                                <td>
                                                    @if ($donation->payment_type == 'membership')
                                                        <a href="{{ url('master/donation/membership-receipt') }}"
                                                            class="btn btn-sm btn-warning">
                                                            <i class="fa fa-receipt"></i> Receipt
                                                        </a>
                                                    @else
                                                        <a href="{{ url('master/donation/donation-receipt?id=' . $donation->id) }}"
                                                            class="btn btn-sm btn-warning">
                                                            <i class="fa fa-receipt"></i> Receipt
                                                        </a>
                                                    @endif
                                                </td>

                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
