@extends(config('app.admin.view').".layouts.master")

@section('title')
    Add Partner
@endsection

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Add Partner</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Add Partner </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Partner Add</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'partner' }}">
                                    <i class="fa fa-list"></i> Partner List</a>
                            </div>

                            <form action="{{ config('app.admin.url') . 'partner/store' }}" method="POST"
                                class="form-style3" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">

                                    <div class="row">
                                        <div class="col-md-6">
                                            

                                            

                                    <div class="form-group">
                                        <label for="image">Image </label>
                                        <input type="file" name="image" id="image" class="dropify"
                                            accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp"
                                            data-max-file-size="2M">
                                    </div>

                                    
                                    <div class="form-group mt-4">
                                        <label for="title">Title</label>
                                        <input type="text" class="form-control" id="title" name="title"
                                            value="{{ old('title') }}">
                                    </div>

                                  
                                    {{-- </div> --}}
                                    {{-- <div class="col-md-6">

                                          <div class="form-group">
                                        <label for="exampleInputEmail1">Tag</label>
                                        <input type="text" name="tag" class="form-control"
                                            placeholder="Partner Tag (Ex. 'cooking')">
                                    </div> --}}

                                    {{-- <div class="form-group">
                                        <label for="exampleInputEmail1">Category</label>
                                        <select name="menu2"  class="form-control">
                                            <option value="">-- Select Category --</option>
                                            <option value="commercial">Commercial</option>
                                            <option value="residential">Residential</option>
                                            <option value="flooring">Flooring</option>
                                            <option value="joinery">Joinery</option>
                                            <option value="furnishing">Furnishing</option>
                                        </select>
                                    </div> --}}
                                    
                                  
                                     <div class="form-group">
                                        <label for="exampleInputEmail1">Home</label>
                                        <select name="home" class="form-control">
                                            <option value="1">Active</option>
                                            <option value="0">Disabled</option>
                                        </select>
                                    </div>

                                     <div class="form-group">
                                        <label for="exampleInputEmail1">Status</label>
                                        <select name="status" class="form-control">
                                            <option value="1">Active</option>
                                            <option value="0">Disabled</option>
                                        </select>
                                    </div>

                                    </div>
                                    </div>
                                    

                                </div>

                                <div class="card-footer text-right">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

@endsection
