@extends(config('app.admin.view').".layouts.master")

@section('title')
    Industry List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Industry List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Industry List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Industry List</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'industry/create' }}">
                                    <i class="fa fa-plus"></i> Add Industry</a>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Industry</th>
                                            <th>Short Description</th>
                                            <th>Status</th>
                                            <th>Addon</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($industrys as $key=> $industry)

                                        <tr>
                                            <td>{{ $key+1 }}.</td>
                                            <td>{{ $industry['name'] }}</td>
                                            <td>{{ $industry->shortDescription() }}</td>
                                            <td>
                                                @if ($industry['status'] == 1)
                                                    Active
                                                @else
                                                    Not Active
                                                @endif
                                            </td>
                                            <td>{{ $industry['created_at']->format('d/m/Y') }}</td>
                                            <td>
                                                <a class="btn btn-info btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'industry/show/'.encrypt($industry->id)) }}"
                                                    title="Show"><i class="fa fa-eye"></i></a>
                                                <a class="btn btn-primary btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'industry/edit/'.encrypt($industry->id)) }}"
                                                    title="Edit"><i class="fa fa-edit"></i></a>
                                                <a class="btn btn-danger btn-sm my-1"
                                                    href="{{ (config('app.admin.url').'industry/destroy/'.encrypt($industry->id)) }}"
                                                    title="Delete"><i class="fa fa-trash"></i></a>
                                            </td>
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
