@extends(config('app.admin.view') . '.layouts.master')

@section('title')
    Gallery View
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Gallery View</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Gallery View </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">



                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Gallery View</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'gallery' }}">
                                    <i class="fa fa-list"></i> Gallery List</a>
                            </div>


                            <div class="row">
                                
                               
                                <div class="col-md-6">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="image">Image</label>
                                            <img src="{{ asset('assets/gallery/' . $gallery->image) }}"
                                                class="img-fluid img-thumbnail" alt="{{ $gallery->title }}" />
                                            <a href="{{ asset('assets/gallery/' . $gallery->image) }}"
                                                target="new" class="btn btn-default form-control">Go to File</a>
                                        </div>

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="card-body">
{{--                                       
                                        <div class="form-group">
                                            <label for="title">Menu Name</label>
                                            <input type="text" class="form-control text-uppercase" id="menu" name="menu"
                                                disabled value="{{ $gallery->menu2 }}">
                                        </div> --}}
                                      
                                        <div class="form-group">
                                            <label for="title">Gallery Title</label>
                                            <input type="text" class="form-control" id="title" name="title"
                                                disabled value="{{ $gallery->title }}">
                                        </div>
                                        
                                        
                                        {{-- <div class="form-group">
                                            <label for="title">Gallery Tag</label>
                                            <input type="text" class="form-control" id="tag" name="tag"
                                                disabled value="{{ $gallery->tag }}">
                                        </div> --}}

                                        
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Status</label>
                                            <select name="status" class="form-control" disabled>
                                                <option value="1" @if ($gallery->status == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($gallery->status == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Home</label>
                                            <select name="home" class="form-control" disabled>
                                                <option value="1" @if ($gallery->home == 1) selected @endif>
                                                    Active</option>
                                                <option value="0" @if ($gallery->home == 0) selected @endif>
                                                    Disabled</option>
                                            </select>

                                        </div>

                                       
                                    </div>
                                    </div>
                              

                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>
@endsection
