@extends(config('app.admin.view').".layouts.master")

@section("title") Edit Gallery @endsection

@section("content")

        <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
          
          <!-- Content Header (Page header) -->
          <section class="content-header">
            <div class="container-fluid">
              <div class="row mb-2">
                <div class="col-sm-6">
                  <h4>Edit Gallery</h4>
                </div>
                <div class="col-sm-6">
                  <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#"> Home </a></li>
                    <li class="breadcrumb-item active"> Edit Gallery </li>
                  </ol>
                </div>
              </div>
            </div>
          </section>
          <!-- Content Header (Page header) -->
          
          <!-- Main content -->
          <section class="content">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-md-12 mb-4 mt-0">

                   

                        <div class="card card-primary">
                          <div class="card-header">
                                <h2 class="card-title">Edit Gallery</h2>
                                <a class="btn btn-dark text-white btn-xs float-right"
                                    href="{{ config('app.admin.url') . 'gallery' }}">
                                    <i class="fa fa-list"></i> Gallery List</a>
                            </div>

                            <form action="{{ (config('app.admin.url').'gallery/update/'.encrypt($gallery->id)) }}" method="POST" class="form-style3" enctype="multipart/form-data">
                            @csrf
                            @method('PATCH')
                            <div class="card-body">

                              
                                    <div class="row">
                                        <div class="col-md-6">
                              
                                   <div class="form-group">
                                  <label for="image"> Image</label>
                                  <input type="file" name="image" id="image" class="dropify mb-2"
                                      accept="image/png, image/jpeg, image/jpg, image/gif, image/svg, image/webp" data-default-file="{{ asset('assets/gallery/'.$gallery->image) }}"
                                      data-max-file-size="2M">
                                      <a href="{{ asset('assets/gallery/'.$gallery->image) }}" target="new" class="btn btn-default form-control">Go to File</a>
                              </div>

                              
                              <div class="form-group">
                                        <label for="exampleInputEmail1">Gallery Title</label>
                                        <input type="text" name="title" class="form-control"
                                            placeholder="Gallery Title" value="{{ $gallery->title }}">
                                    </div>
                                        </div>
                                         <div class="col-md-6">
                         
                              
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Home</label>
                                                <select name="home" class="form-control">
                                                    <option value="1" @if ($gallery->home==1) selected @endif>Active</option>
                                                    <option value="0" @if ($gallery->home==0) selected @endif>Disabled</option>
                                                </select>
                                            </div>
                             

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="1" @if ($gallery->status==1) selected @endif>Active</option>
                                                    <option value="0" @if ($gallery->status==0) selected @endif>Disabled</option>
                                                </select>
                                            </div>
                                            </div>
                                            </div>
                            </div>
                              <div class="card-footer text-right">
                              <button type="submit" class="btn btn-primary">Submit</button>
                              </div>
                            </form>
                            </div>    
                      </div>
                  </div>
              </div>
          </section>
    </div>

@endsection