@extends(config('app.admin.view') . '.layouts.master')

@section('title', 'Donation Receipt')

@section('content')
    <div class="content-wrapper">
        <section class="content-header">
            <h4>Donation Receipt</h4>
        </section>

        <section class="content">
            <div class="container-fluid">
                @if ($donation && $donation->payment_type === 'donation')
                    <div class="d-flex justify-content-center">
                        <!-- Wrap receipt in #donation-receipt for PDF -->
                        <div id="donation-receipt" class="card p-4" style="width: 700px; border:1px solid #ccc;">
                            <!-- Header with Logo & Organization Name -->
                            <div class="d-flex align-items-center mb-3" style="padding-bottom:10px;">
                                <!-- Logo -->
                                <div style="flex:0 0 auto; background-color: #000; border-radius: 50%;">
                                    <img src="{{ asset('logo-1726730459.webp') }}" alt="Logo" style="height:60px;">
                                </div>
                                <!-- Organization Name -->
                                <div class="flex-grow-1 text-center">
                                    <h4 class="mb-0">GMM Educational Trust And Welfare Association</h4>
                                </div>
                                <!-- Empty space for right balance -->
                                <div style="flex:0 0 auto; width:60px;"></div>
                            </div>

                            <div class="text-center mb-3">
                                <h5 class="mb-0">Donation Payment Receipt</h5>
                                <small class="text-muted">Acknowledgement Slip</small>
                                <hr>
                            </div>

                            <table class="table table-sm table-bordered mb-0">
                                <tr>
                                    <td><strong>Name</strong></td>
                                    <td>{{ $user->name }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Email</strong></td>
                                    <td>{{ $user->email }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Phone</strong></td>
                                    <td>{{ $user->phone ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Amount Paid</strong></td>
                                    <td>₹{{ $donation->amount }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Payment Type</strong></td>
                                    <td>{{ ucfirst($donation->payment_type) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>UTR Number</strong></td>
                                    <td>{{ $donation->utr_number }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Status</strong></td>
                                    <td>
                                        @if ($donation->status === 'confirmed')
                                            <span>Confirmed</span>
                                        @elseif($donation->status === 'pending')
                                            <span class="badge bg-warning text-dark">Pending</span>
                                        @else
                                            <span class="badge bg-danger">Rejected</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Date</strong></td>
                                    <td>{{ $donation->created_at->format('d-m-Y') }}</td>
                                </tr>
                            </table>

                            <div class="text-center mt-3">
                                <small class="text-muted">This is a system generated slip.</small>
                            </div>
                        </div>

                    </div>

                    <!-- Action / Message depending on status -->
                    <div class="text-center mt-3">
                        @if ($donation->status === 'confirmed')
                            <button onclick="downloadDonationPDF()" class="btn btn-primary">
                                <i class="fa fa-download"></i> Download PDF
                            </button>
                        @elseif($donation->status === 'pending')
                            <div class="alert alert-info mt-3">
                                Your donation is under review. Please wait for <strong>24–48 hours</strong> for
                                confirmation.
                            </div>
                        @elseif($donation->status === 'rejected')
                            <div class="alert alert-danger mt-3">
                                Sorry, your donation has been <strong>rejected</strong>.
                                Please <span><a href="/gmm/contact">contact support</a></span> if you believe this is a
                                mistake.
                            </div>
                        @endif
                    </div>
                @else
                    <div class="card p-4">
                        <div class="alert alert-warning mb-0">
                            You have not donated yet.
                            <a href="{{ url('/master/donation') }}">Donate now</a>.
                        </div>
                    </div>
                @endif
            </div>
        </section>
    </div>

    <!-- JS for html2pdf -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script>
        function downloadDonationPDF() {
            const element = document.getElementById("donation-receipt");
            html2pdf().set({
                margin: 0.3,
                filename: 'donation-receipt.pdf',
                image: {
                    type: 'jpeg',
                    quality: 0.95
                },
                html2canvas: {
                    scale: 2
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4',
                    orientation: 'portrait'
                }
            }).from(element).save();
        }
    </script>
@endsection
