@extends(config('app.admin.view') . '.layouts.master')

@section('title', 'Donate Now')

@section('content')
    <div class="content-wrapper">

        <!-- Page Header -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Donate Now</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Panel</a></li>
                            <li class="breadcrumb-item active">Donate</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main Content -->
        <section class="content">
            <div class="container-fluid">

                <!-- Changed from card-success → card-primary -->
                <div class="card card-primary shadow">
                    <div class="card-header">
                        <h3 class="card-title">Make a Donation</h3>
                    </div>

                    <form action="{{ url('master/donation') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body row">

                            <!-- QR Code & Payment Details -->
                            <div class="col-md-12 mb-4">
                                <div class="row d-flex align-items-center">
                                    <!-- QR Code -->
                                    <div class="col-md-6 text-center">
                                        <label><strong>Scan this QR Code to Pay</strong></label>
                                        <div>
                                            <img src="{{asset($settings->upi_qr_code)}}" alt="Donation QR" class="img-fluid"
                                                style="max-width: 250px; border: 2px solid #ccc; border-radius: 10px;">
                                        </div>
                                    </div>

                                    <!-- Payment Details -->
                                    <div class="col-md-6">
                                        <div
                                            class="border rounded p-4 bg-light h-100 d-flex flex-column justify-content-center">
                                            <h5 class="mb-3"><strong>Payment Details</strong></h5>
                                            <p class="mb-2"><strong>Account Holder:</strong> {{$settings->account_holder}}</p>
                                            <p class="mb-2"><strong>Bank Name:</strong> {{$settings->bank_name}}</p>
                                            <p class="mb-2"><strong>Account Number:</strong> {{$settings->account_number}}</p>
                                            <p class="mb-2"><strong>IFSC Code:</strong> {{$settings->ifsc_code}}</p>
                                            <p class="mb-2"><strong>Branch Name:</strong> {{$settings->branch_name}}</p>
                                            <p class="mb-0"><strong>UPI ID:</strong> {{$settings->upi_id}}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_type">Type of Payment *</label>
                                    <select class="form-control" id="payment_type" name="payment_type" required disabled>
                                        <option value="membership" @if (session('type') || request('type') === 'membership') selected @endif>
                                            Membership Fee
                                        </option>
                                        <option value="donation" @if (!session('type') && request('type') !== 'membership') selected @endif>
                                            Donation
                                        </option>
                                    </select>
                                    <!-- hidden input to submit actual value since disabled won't post -->
                                    <input type="hidden" name="payment_type"
                                        value="{{ session('type') || request('type') === 'membership' ? 'membership' : 'donation' }}">
                                </div>
                            </div>


                            <!-- Amount Input -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Amount *</label>
                                    <input type="number" class="form-control" id="amount" name="amount"
                                        value="{{ session('amount') ?? request('amount') }}"
                                        @if (session('type') || request('type')) readonly @endif required>

                                </div>
                            </div>

                            <!-- UTR Input -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="utr_number">UTR Number *</label>
                                    <input type="text" class="form-control" id="utr_number" name="utr_number"
                                        placeholder="Enter UTR Number" required>
                                </div>
                            </div>

                            <!-- Screenshot Upload -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="screenshot">Upload Payment Screenshot *</label>
                                    <input type="file" class="form-control" id="screenshot" name="screenshot"
                                        accept="image/*" required>
                                </div>
                            </div>

                        </div>

                        <!-- Changed btn-success → btn-primary -->
                        <div class="card-footer text-center">
                            <button type="submit" class="btn btn-primary">Submit Donation</button>
                        </div>
                    </form>
                </div>

            </div>
        </section>
    </div>
@endsection
