@extends(config('app.admin.view').".layouts.master")

@section('title')
    Volunteer List
@endsection

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4>Volunteer List</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#"> Home </a></li>
                            <li class="breadcrumb-item active"> Volunteer List </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 mb-4 mt-0">

                        <div class="card card-primary">
                            <div class="card-header">
                                <h2 class="card-title">Volunteer List</h2>
                                
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped display">
                                    <thead>
                                        <tr>
                                            <th>S.No.</th>
                                            <th>Name</th>
                                            <th>Phone</th>
                                            <th>Email</th>
                                            <th>City</th>
                                            <th>CV</th>
                                            <th>Status</th>
                                            <th>Addon</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($careers as $key=> $career)

                                        <tr>
                                            <td>{{ $key+1 }}.</td>
                                            <td>{{ $career['name'] }}</td>
                                            <td>{{ $career['phone'] }}</td>
                                            <td>{{ $career['email'] }}</td>
                                            <td>{{ $career['city'] }}</td>
                                            <td>
                                                <a target="_blank" href="{{ asset("assets/career/".$career['file']) }}" class="btn btn-sm btn-primary">View PDF</a>
                                            </td>
                                            <td>
                                                @if ($career['status'] == 1)
                                                    Active
                                                @else
                                                    Not Active
                                                @endif
                                            </td>
                                            <td>{{ $career['created_at']->format('d/m/Y h:i A') }}</td>
                                         
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
