<?php

namespace App\Providers;

use App\Models\Product;
use App\Models\Setting;
use App\Models\Dynamic;
use App\Models\User;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (config('app.url') !== request()->root()) {
            $this->app['url']->forceRootUrl(config('app.url'));
        }

        view()->composer('layouts.master', function ($view) {
            $settings = Setting::where('id', '1')->first();
            $settings['projects'] = Product::where('status', '1')->where('home', '1')->get();
            $settings['projects2'] = Product::where('status', '1')->get();
            $settings['pages'] = Dynamic::where('status', '1')->where('page', 'custom')->where('navbar', '0')->get();

            $view->with('settings', $settings);
        });

        view()->composer('admin.layouts.master', function ($view) {
            $settings = Setting::where('id', '1')->first();
            $user_data = session('user_data');
            $user = User::where('email', $user_data->email)->select('name', 'email', 'password', 'photo', 'role', 'status')->first();

            $view->with(array('settings' => $settings, 'user' => $user));
        });
    }
}
