<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Str;

class Product extends Model
{
    protected $fillable = ['name', 'title', 'image', 'banner','catalogue', 'details', 'meta_keywords', 'meta_description', 'additional', 'slug', 'home', 'status'];

    public function shortDescription()
    {
        return Str::words($this->meta_description, 18);
    }

    use Notifiable;
}
