<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Str;

class Events extends Model
{
    protected $fillable = ['name', 'title', 'image', 'banner', 'details', 'meta_keywords', 'meta_description', 'additional', 'slug', 'home', 'status'];

    public function shortDescription()
    {
        return Str::words($this->meta_description, 20);
    }

    use Notifiable;
}
