<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;


class UserController extends Controller
{

    public function index()
    {
        return view(config('app.admin.view') . '.user.index', ['users' => User::where('role','<>','developer')->get()]);
    }

    public function create()
    {
        return view(config('app.admin.view') . '.user.create');
    }

    public function store(Request $request)
    {

        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required
        $validatedData = $request->validate($errors); // all fields validation

        $file = "photo";

        $destinationPath = public_path('/Panel/users/');

        $image = $request->file($file);
       
        if ($image) {

            if ($request->hasFile($file)) {
                $request->validate([$file => 'required|image|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

                $imagename = time() . '.png';
                $image->move($destinationPath, $imagename);

                // Resize and optimize the image using Intervention/Image package
                $img = Image::make($destinationPath."".$imagename);
                // Resize and store the image for the meta image
                $img->encode('webp', 90);
                $img->save($destinationPath . "" . $imagename);


                $validatedData[$file] = $imagename;
            }

        }

        if ($validatedData['password'] == $validatedData['confiirm_password']) {
            return redirect(config('app.admin.route') . '/user/create')->with('error', 'Password and Confirm Password does not matched');
        }

        
        $validatedData['password'] = Hash::make($validatedData['password']);
        $validatedData['remember_token'] = $validatedData['password'];


        User::create($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/user/create')->with('success', 'User added successfully');
    }

    public function show($id)
    {
        $id = decrypt($id);
        $user = User::find($id);
        return view(config('app.admin.view') . '.user.show', compact('user'));
    }

    public function edit($id)
    {
        $id = decrypt($id);
        $user = User::find($id);
        return view(config('app.admin.view') . '.user.edit', compact('user'));
    }

    public function update(Request $request, $id)
    {
        $xid = decrypt($id);

        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 2); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation

        User::whereId($xid)->update($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/user/edit/' . $id)->with('success', 'User has been updated');
    }

    public function destroy($id)
    {
        $id = decrypt($id);
        $user = User::find($id);
        $user->delete();

        return redirect(config('app.admin.route') . '/user')->with('success', 'User has been deleted');
    }
}
