<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Donate;
use App\Models\State;
use App\Models\District;
use App\Models\Sport;
use App\Models\Agriculture;
use App\Models\Scholarship;
use App\Models\Volunteer;
use App\Models\Membership;
use App\Models\Donation;

class ReportController extends Controller
{

    public function donate()
    {
        return view(config('app.admin.view') . '.reports.donate', ['donates' => Donate::all()]);
    }

    public function donatedestroy($id)
    {
        $id = decrypt($id);
        $donate = Donate::find($id);
        $donate->delete();

        return redirect(config('app.admin.route') . '/donate')->with('success', 'Donate details has been deleted');
    }

    public function scholarship()
    {
        return view(config('app.admin.view') . '.reports.scholarship', ['scholarships' => Scholarship::all()]);
    }

    public function scholarshipshow($id)
    {
        $id = decrypt($id);
        $scholarship = Scholarship::find($id);

        $st = State::where('state_id', $scholarship->state)->first();
        $scholarship['state_name'] = $st->state_title;

        $dt = District::where('districtid', $scholarship->district)->first();
        $scholarship['district_name'] = $dt->district_title;
        return view(config('app.admin.view') . '.reports.scholarshipshow', compact('scholarship'));
    }

    public function scholarshipdestroy($id)
    {
        $id = decrypt($id);
        $scholarship = Scholarship::find($id);
        $scholarship->delete();

        return redirect(config('app.admin.route') . '/scholarship')->with('success', 'Scholarship details has been deleted');
    }

    public function sports()
    {
        return view(config('app.admin.view') . '.reports.sports', ['sports' => Sport::all()]);
    }

    public function sportsshow($id)
    {
        $id = decrypt($id);
        $sports = Sport::find($id);

        $st = State::where('state_id', $sports->state)->first();
        $sports['state_name'] = $st->state_title;

        $dt = District::where('districtid', $sports->district)->first();
        $sports['district_name'] = $dt->district_title;
        return view(config('app.admin.view') . '.reports.sportsshow', compact('sports'));
    }

    public function sportsdestroy($id)
    {
        $id = decrypt($id);
        $sports = Sport::find($id);
        $sports->delete();

        return redirect(config('app.admin.route') . '/sports')->with('success', 'Sport details has been deleted');
    }


    public function agriculture()
    {
        return view(config('app.admin.view') . '.reports.agriculture', ['agriculture' => Agriculture::all()]);
    }

    public function agricultureshow($id)
    {
        $id = decrypt($id);
        $agriculture = Agriculture::find($id);

        $st = State::where('state_id', $agriculture->state)->first();
        $agriculture['state_name'] = $st->state_title;

        $dt = District::where('districtid', $agriculture->district)->first();
        $agriculture['district_name'] = $dt->district_title;
        return view(config('app.admin.view') . '.reports.agricultureshow', compact('agriculture'));
    }

    public function agriculturedestroy($id)
    {
        $id = decrypt($id);
        $agriculture = Agriculture::find($id);
        $agriculture->delete();

        return redirect(config('app.admin.route') . '/agriculture')->with('success', 'Agriculture details has been deleted');
    }


    public function volunteer()
    {
        return view(config('app.admin.view') . '.reports.volunteer', ['volunteers' => Volunteer::all()]);
    }


    public function volunteerdestroy($id)
    {
        $id = decrypt($id);
        $volunteer = Volunteer::find($id);
        $volunteer->delete();

        return redirect(config('app.admin.route') . '/volunteer')->with('success', 'Volunteer details has been deleted');
    }


    public function membershipList()
    {
        return view(config('app.admin.view') . '.reports.membership', ['memberships' => Membership::all()]);
    }

    public function donationList()
    {
        return view(config('app.admin.view') . '.reports.donation', ['donations' => Donation::all()]);
    }
}
