<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    public function index()
    {
        if (!empty(session('user_data'))) {
            $sdata = session('user_data');

            $users = DB::table('users')
            ->where('email', $sdata->email)
                ->where('password', $sdata->password)
                ->select('name', 'email', 'password', 'photo', 'role', 'status')
                ->first();;
            if (isset($users->name)) {
                session(['user_data' => $users]);
                return redirect(config('app.admin.route').'/dashboard');
            }
        }

        return view(config('app.admin.view') . '.login');
    }

    public function authenticate(Request $request)
    {
        $email = $request->input('email');
        $password = $request->input('password');

        $users = User::where('email', $email)->select('name', 'email', 'password', 'photo', 'role', 'status')->first();
        if ($users) {
            if (Hash::check($password, $users->password)){
                if($users->status == 1){
                    session(['user_data' => $users]);
                    return redirect(config('app.admin.route').'/dashboard');
                } else {
                    session(['flash' => ['message' => 'Account Deactivated', 'msg_type' => 'error', 'error_type' => 'danger']]);
                    return redirect(config('app.admin.route').'');
                }
                
            } else {
                session(['flash' => ['message' => 'Wrong Password', 'msg_type' => 'error', 'error_type' => 'danger']]);
                return redirect(config('app.admin.route').'');
            }
            
        } else {
            session(['flash' => ['message' => 'Invalid User details', 'msg_type' => 'error', 'error_type' => 'danger']]);
            return redirect(config('app.admin.route').'');
        }
    }

    public function logout()
    {
        session()->flush();
        session(['flash' => ['message' => 'Logout Successfull', 'msg_type' => 'success', 'error_type' => 'success']]);
        return redirect(config('app.admin.route'));
    }
}
