<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Contact;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;

class ContactController extends Controller
{

    public function index()
    {
        return view(config('app.admin.view') . '.contact.index', ['contacts' => Contact::all()]);
    }
	
	public function destroy($id)
    {
        $id = decrypt($id);
        $contact = Contact::find($id);
        $contact->delete();

        return redirect(config('app.admin.route') . '/contact')->with('success', 'Contact Inquiry has been deleted');
    }
	
}