<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Post;
use App\Models\Setting;
use App\Models\User;
use App\Models\Volunteer;
use App\Models\Donation;
use App\Models\Membership;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;

class AdminController extends Controller
{
    // public function index()
    // {
    //     $user_data = session('user_data');
    //     if ($user_data && $user_data->role == 'developer') {
    //         return view(config('app.admin.view') . '.dashboard');
    //     } elseif ($user_data && $user_data->role == 'volunteer') {
    //         return view(config('app.admin.view') . '.home');
    //     } else {
    //         abort(404);
    //     }
    // }

    public function index()
    {
        $user_data = session('user_data');

        if ($user_data && $user_data->role == 'developer') {
            // Total counts
            $volunteersCount = Volunteer::count();
            $donationsCount = Donation::count();
            $membershipsCount = Membership::count();

            // Today ke counts (created_at ka filter)
            $today = now()->toDateString();

            $todayVolunteers = Volunteer::whereDate('created_at', $today)->count();
            $todayDonations = Donation::whereDate('created_at', $today)->count();
            $todayMemberships = Membership::whereDate('created_at', $today)->count();

            return view(config('app.admin.view') . '.dashboard', compact(
                'volunteersCount',
                'donationsCount',
                'membershipsCount',
                'todayVolunteers',
                'todayDonations',
                'todayMemberships'
            ));
        } elseif ($user_data && $user_data->role == 'volunteer') {
            return view(config('app.admin.view') . '.home');
        } else {
            abort(404);
        }
    }


    public function profile()
    {
        $user_data = session('user_data');
        $user = User::where("email", session('user_data')->email)->first();
        return view(config('app.admin.view') . '.profile', compact('user'));
    }




    public function settings()
    {
        if (session('user_data')->role == 'developer') {
            $settings = Setting::first();
            return view(config('app.admin.view') . '.settings', compact('settings'));
        } else {
            abort(404);
        }
    }

    public function update(Request $request, $file = null)
    {
        $xid = 1;


        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation
        $destinationPath = public_path('/');

        if ($file) {
            $image = $request->file($file);

            $oldFile = Setting::whereId($xid)->value($file);
            $validatedData[$file] = $oldFile;

            if ($request->hasFile($file)) {
                $request->validate([$file => 'required|image|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

                // Delete old file if it exists and is not null
                if ($oldFile && File::exists($destinationPath . $oldFile) && !is_dir($destinationPath . $oldFile)) {
                    unlink($destinationPath . $oldFile);
                }

                $imagename = $file . '-' . time() . '.png';
                $imagename2 = $file . '-' . time() . '.webp';
                $image->move($destinationPath, $imagename);

                $img = Image::make($destinationPath . $imagename);
                $img->encode('webp', 90);
                $img->save($destinationPath . $imagename2);

                unlink($destinationPath . $imagename);

                $validatedData[$file] = $imagename2;
            }
        }


        Setting::whereId($xid)->update($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/settings')->with('success', 'Settings has been updated');
    }

    public function updatecat(Request $request, $file = null)
    {
        $xid = 1;



        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation
        $destinationPath = public_path('/');

        if ($file) {
            $filex = $request->file($file);

            $validatedData[$file] = Setting::whereId($xid)->pluck($file)->first();
            if ($request->hasFile($file)) {
                $request->validate([$file => 'required']);

                if (isset($validatedData[$file]) && File::exists($destinationPath . $validatedData[$file])) {
                    unlink($destinationPath . $validatedData[$file]);
                }

                $imagename = $file . '-' . time() . $filex->getClientOriginalExtension();;
                $filex->move($destinationPath, $imagename);

                $validatedData[$file] = $imagename;
            }
        }

        Setting::whereId($xid)->update($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/settings')->with('success', 'Settings has been updated');
    }


    public function profile_update(Request $request)
    {

        $user_data = session('user_data');
        $user = User::where("email", session('user_data')->email)->first();



        $input = array_keys($request->input()); // all inputs
        array_splice($input, 0, 1); // removing _token & _method
        $errors = array_fill_keys($input, 'required'); // all fields are required

        $validatedData = $request->validate($errors); // all fields validation
        $destinationPath = public_path('/Panel/users/');



        $file = "photo";
        if ($file) {
            $image = $request->file($file);


            $validatedData[$file] = $user->photo;
            if ($request->hasFile($file)) {
                $request->validate([$file => 'required|image|mimes:jpg,png,jpeg,gif,svg,webp|max:2048']);

                if (File::exists($destinationPath . $validatedData[$file])) {
                    unlink($destinationPath . $validatedData[$file]);
                }

                $imagename = $file . '-' . time() . '.png';
                $imagename2 = $file . '-' . time() . '.webp';
                $image->move($destinationPath, $imagename);

                // Resize and optimize the image using Intervention/Image package
                $img = Image::make($destinationPath . "" . $imagename);
                // Resize and store the image for the meta image
                $img->encode('webp', 90);
                $img->save($destinationPath . "" . $imagename2);
                unlink($destinationPath . "" . $imagename);


                $validatedData[$file] = $imagename2;
            }
        }

        User::whereId($user->id)->update($validatedData); // saving the data

        return redirect(config('app.admin.route') . '/profile')->with('success', 'Profile has been updated');
    }
}
